/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.txn.Attribute;
import org.jboss.as.txn.Element;
import org.jboss.as.txn.Namespace;
import org.jboss.as.txn.TransactionSubsystemAdd;
import org.jboss.as.txn.TransactionSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class TransactionExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.txn");
    public static final String SUBSYSTEM_NAME = "transactions";
    private static final TransactionSubsystemParser parser = new TransactionSubsystemParser();

    public void initialize(ExtensionContext context) {
        log.debug((Object)"Initializing Transactions Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(TransactionSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationHandler)TransactionSubsystemAdd.INSTANCE, TransactionSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationHandler)TransactionDescribeHandler.INSTANCE, (DescriptionProvider)TransactionDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)parser);
    }

    private static ModelNode createEmptyAddOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    private static class TransactionDescribeHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        static final TransactionDescribeHandler INSTANCE = new TransactionDescribeHandler();

        private TransactionDescribeHandler() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode add = TransactionExtension.createEmptyAddOperation();
            ModelNode model = context.getSubModel();
            if (model.hasDefined("core-environment")) {
                add.get("core-environment").set(model.get("core-environment"));
            }
            if (model.hasDefined("recovery-environment")) {
                add.get("recovery-environment").set(model.get("recovery-environment"));
            }
            if (model.hasDefined("coordinator-environment")) {
                add.get("coordinator-environment").set(model.get("coordinator-environment"));
            }
            if (model.hasDefined("object-store")) {
                add.get("object-store").set(model.get("object-store"));
            }
            ModelNode result = new ModelNode();
            result.add(add);
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static class TransactionSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        TransactionSubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            if (reader.getAttributeCount() > 0) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
            }
            ModelNode subsystem = TransactionExtension.createEmptyAddOperation();
            list.add(subsystem);
            EnumSet<Element> required = EnumSet.of(Element.RECOVERY_ENVIRONMENT, Element.CORE_ENVIRONMENT);
            EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
            block9: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case TRANSACTIONS_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        required.remove((Object)element);
                        if (!encountered.add(element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        switch (element) {
                            case RECOVERY_ENVIRONMENT: {
                                ModelNode model = TransactionSubsystemParser.parseRecoveryEnvironmentElement(reader);
                                subsystem.get("recovery-environment").set(model);
                                continue block9;
                            }
                            case CORE_ENVIRONMENT: {
                                ModelNode model = TransactionSubsystemParser.parseCoreEnvironmentElement(reader);
                                subsystem.get("core-environment").set(model);
                                continue block9;
                            }
                            case COORDINATOR_ENVIRONMENT: {
                                ModelNode model = TransactionSubsystemParser.parseCoordinatorEnvironmentElement(reader);
                                subsystem.get("coordinator-environment").set(model);
                                continue block9;
                            }
                            case OBJECT_STORE: {
                                ModelNode model = TransactionSubsystemParser.parseObjectStoreEnvironmentElement(reader);
                                subsystem.get("object-store").set(model);
                                continue block9;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!required.isEmpty()) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
            }
        }

        static ModelNode parseObjectStoreEnvironmentElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode store = new ModelNode();
            int count = reader.getAttributeCount();
            block4: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case RELATIVE_TO: {
                        store.get("relative-to").set(value);
                        continue block4;
                    }
                    case PATH: {
                        store.get("path").set(value);
                        continue block4;
                    }
                    default: {
                        ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return store;
        }

        static ModelNode parseCoordinatorEnvironmentElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode coordinator = new ModelNode();
            int count = reader.getAttributeCount();
            block4: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ENABLE_STATISTICS: {
                        coordinator.get("enable-statistics").set(value);
                        continue block4;
                    }
                    case DEFAULT_TIMEOUT: {
                        coordinator.get("default-timeout").set(value);
                        continue block4;
                    }
                    default: {
                        ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return coordinator;
        }

        static ModelNode parseCoreEnvironmentElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode env = new ModelNode();
            int count = reader.getAttributeCount();
            EnumSet<Attribute> required = EnumSet.of(Attribute.BINDING);
            block5: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                required.remove((Object)attribute);
                switch (attribute) {
                    case BINDING: {
                        env.get("socket-binding").set(value);
                        continue block5;
                    }
                    case NODE_IDENTIFIER: {
                        env.get("node-identifier").set(value);
                        continue block5;
                    }
                    case SOCKET_PROCESS_ID_MAX_PORTS: {
                        env.get("socket-process-id-max-ports").set(value);
                        continue block5;
                    }
                    default: {
                        ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!required.isEmpty()) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return env;
        }

        static ModelNode parseRecoveryEnvironmentElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode env = new ModelNode();
            int count = reader.getAttributeCount();
            block4: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case BINDING: {
                        env.get("socket-binding").set(value);
                        continue block4;
                    }
                    case STATUS_BINDING: {
                        env.get("status-socket-binding").set(value);
                        continue block4;
                    }
                    default: {
                        ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!env.has("socket-binding")) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BINDING));
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return env;
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            ModelNode env;
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            if (this.has(node, "core-environment")) {
                writer.writeStartElement(Element.CORE_ENVIRONMENT.getLocalName());
                ModelNode core = node.get("core-environment");
                if (this.has(core, "socket-binding")) {
                    this.writeAttribute(writer, Attribute.BINDING, core.get("socket-binding"));
                }
                if (this.has(core, "node-identifier")) {
                    this.writeAttribute(writer, Attribute.NODE_IDENTIFIER, core.get("node-identifier"));
                }
                if (this.has(core, "socket-process-id-max-ports")) {
                    this.writeAttribute(writer, Attribute.SOCKET_PROCESS_ID_MAX_PORTS, core.get("socket-process-id-max-ports"));
                }
                writer.writeEndElement();
            }
            if (this.has(node, "recovery-environment")) {
                writer.writeStartElement(Element.RECOVERY_ENVIRONMENT.getLocalName());
                env = node.get("recovery-environment");
                if (this.has(env, "socket-binding")) {
                    this.writeAttribute(writer, Attribute.BINDING, env.get("socket-binding"));
                }
                if (this.has(env, "status-socket-binding")) {
                    this.writeAttribute(writer, Attribute.STATUS_BINDING, env.get("status-socket-binding"));
                }
                writer.writeEndElement();
            }
            if (this.has(node, "coordinator-environment")) {
                writer.writeStartElement(Element.COORDINATOR_ENVIRONMENT.getLocalName());
                env = node.get("coordinator-environment");
                if (this.has(env, "enable-statistics")) {
                    this.writeAttribute(writer, Attribute.ENABLE_STATISTICS, env.get("enable-statistics"));
                }
                if (this.has(env, "default-timeout")) {
                    this.writeAttribute(writer, Attribute.DEFAULT_TIMEOUT, env.get("default-timeout"));
                }
                writer.writeEndElement();
            }
            if (this.has(node, "object-store")) {
                writer.writeStartElement(Element.OBJECT_STORE.getLocalName());
                env = node.get("object-store");
                if (this.has(env, "relative-to")) {
                    this.writeAttribute(writer, Attribute.RELATIVE_TO, env.get("relative-to"));
                }
                if (this.has(env, "path")) {
                    this.writeAttribute(writer, Attribute.PATH, env.get("path"));
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
            writer.writeAttribute(attr.getLocalName(), value.asString());
        }
    }
}

