/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import com.arjuna.ats.arjuna.common.CoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.utils.Process;
import com.arjuna.ats.internal.arjuna.utils.UuidProcessId;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class CoreEnvironmentService
implements Service<CoreEnvironmentBean> {
    private final InjectedValue<String> pathInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> socketProcessBindingInjector = new InjectedValue();
    private String nodeIdentifier;
    private String varPath;

    public CoreEnvironmentService(String nodeIdentifier, String varPath) {
        this.nodeIdentifier = nodeIdentifier;
        this.varPath = varPath;
    }

    public CoreEnvironmentBean getValue() throws IllegalStateException, IllegalArgumentException {
        CoreEnvironmentBean coreEnvironmentBean = arjPropertyManager.getCoreEnvironmentBean();
        return coreEnvironmentBean;
    }

    public void start(StartContext context) throws StartException {
        String varDir;
        CoreEnvironmentBean coreEnvironmentBean = arjPropertyManager.getCoreEnvironmentBean();
        if (coreEnvironmentBean.getProcessImplementationClassName() == null) {
            UuidProcessId id = new UuidProcessId();
            coreEnvironmentBean.setProcessImplementation((Process)id);
        }
        coreEnvironmentBean.setNodeIdentifier(this.nodeIdentifier);
        SocketBinding binding = (SocketBinding)this.socketProcessBindingInjector.getOptionalValue();
        if (binding != null) {
            int port = binding.getPort();
            coreEnvironmentBean.setSocketProcessIdPort(port);
        }
        if ((varDir = (String)this.pathInjector.getOptionalValue()) != null && varDir.length() > 0) {
            coreEnvironmentBean.setVarDir(varDir);
        }
    }

    public void stop(StopContext context) {
    }

    InjectedValue<String> getPathInjector() {
        return this.pathInjector;
    }

    Injector<SocketBinding> getSocketProcessBindingInjector() {
        return this.socketProcessBindingInjector;
    }

    public int getSocketProcessIdMaxPorts() {
        return this.getValue().getSocketProcessIdMaxPorts();
    }

    public void setSocketProcessIdMaxPorts(int socketProcessIdMaxPorts) {
        this.getValue().setSocketProcessIdMaxPorts(socketProcessIdMaxPorts);
    }

    public void setProcessImplementationClassName(String clazz) {
        this.getValue().setProcessImplementationClassName(clazz);
    }

    public void setProcessImplementation(Process instance) {
        this.getValue().setProcessImplementation(instance);
    }
}

