/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.internal.arjuna.objectstore.hornetq.HornetqJournalEnvironmentBean;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ArjunaObjectStoreEnvironmentService
implements Service<Void> {
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();
    private final boolean useHornetqJournalStore;
    private final String path;
    private final String pathRef;
    private volatile PathManager.Callback.Handle callbackHandle;

    public ArjunaObjectStoreEnvironmentService(boolean useHornetqJournalStore, String path, String pathRef) {
        this.useHornetqJournalStore = useHornetqJournalStore;
        this.path = path;
        this.pathRef = pathRef;
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public void start(StartContext context) throws StartException {
        this.callbackHandle = ((PathManager)this.pathManagerInjector.getValue()).registerCallback(this.pathRef, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
        String objectStoreDir = ((PathManager)this.pathManagerInjector.getValue()).resolveRelativePathEntry(this.path, this.pathRef);
        ObjectStoreEnvironmentBean defaultActionStoreObjectStoreEnvironmentBean = (ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"default");
        if (this.useHornetqJournalStore) {
            HornetqJournalEnvironmentBean hornetqJournalEnvironmentBean = (HornetqJournalEnvironmentBean)BeanPopulator.getDefaultInstance(HornetqJournalEnvironmentBean.class);
            hornetqJournalEnvironmentBean.setStoreDir(objectStoreDir + "/HornetqObjectStore");
            defaultActionStoreObjectStoreEnvironmentBean.setObjectStoreType("com.arjuna.ats.internal.arjuna.objectstore.hornetq.HornetqObjectStoreAdaptor");
        } else {
            defaultActionStoreObjectStoreEnvironmentBean.setObjectStoreDir(objectStoreDir);
        }
        ObjectStoreEnvironmentBean stateStoreObjectStoreEnvironmentBean = (ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"stateStore");
        stateStoreObjectStoreEnvironmentBean.setObjectStoreDir(objectStoreDir);
        ObjectStoreEnvironmentBean communicationStoreObjectStoreEnvironmentBean = (ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"communicationStore");
        communicationStoreObjectStoreEnvironmentBean.setObjectStoreDir(objectStoreDir);
    }

    public void stop(StopContext context) {
        this.callbackHandle.remove();
    }

    public InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }
}

