/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.jsp;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.as.metadata.parser.jsp.Attribute;
import org.jboss.as.metadata.parser.jsp.Element;
import org.jboss.as.metadata.parser.jsp.TldExtensionMetaDataParser;
import org.jboss.as.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.web.spec.TagFileMetaData;
import org.jboss.metadata.web.spec.TldExtensionMetaData;

public class TagFileMetaDataParser
extends MetaDataElementParser {
    public static TagFileMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        TagFileMetaData tagFile = new TagFileMetaData();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    tagFile.setId(value);
                    continue block9;
                }
                default: {
                    throw TagFileMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionGroupMetaDataParser.parse(reader, descriptionGroup)) {
                if (tagFile.getDescriptionGroup() != null) continue;
                tagFile.setDescriptionGroup(descriptionGroup);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    tagFile.setName(reader.getElementText());
                    continue block10;
                }
                case PATH: {
                    tagFile.setPath(reader.getElementText());
                    continue block10;
                }
                case EXAMPLE: {
                    ArrayList<String> examples = tagFile.getExamples();
                    if (examples == null) {
                        examples = new ArrayList<String>();
                        tagFile.setExamples(examples);
                    }
                    examples.add(reader.getElementText());
                    continue block10;
                }
                case TAG_EXTENSION: {
                    ArrayList<TldExtensionMetaData> extensions = tagFile.getTagExtensions();
                    if (extensions == null) {
                        extensions = new ArrayList<TldExtensionMetaData>();
                        tagFile.setTagExtensions(extensions);
                    }
                    extensions.add(TldExtensionMetaDataParser.parse(reader));
                    continue block10;
                }
            }
            throw TagFileMetaDataParser.unexpectedElement(reader);
        }
        return tagFile;
    }
}

