/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.jsp;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.as.metadata.parser.jsp.Attribute;
import org.jboss.as.metadata.parser.jsp.Element;
import org.jboss.as.metadata.parser.jsp.FunctionMetaDataParser;
import org.jboss.as.metadata.parser.jsp.ListenerMetaDataParser;
import org.jboss.as.metadata.parser.jsp.Location;
import org.jboss.as.metadata.parser.jsp.TagFileMetaDataParser;
import org.jboss.as.metadata.parser.jsp.TagMetaDataParser;
import org.jboss.as.metadata.parser.jsp.TldExtensionMetaDataParser;
import org.jboss.as.metadata.parser.jsp.ValidatorMetaDataParser;
import org.jboss.as.metadata.parser.jsp.Version;
import org.jboss.as.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.web.spec.FunctionMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.TagFileMetaData;
import org.jboss.metadata.web.spec.TagMetaData;
import org.jboss.metadata.web.spec.Tld11MetaData;
import org.jboss.metadata.web.spec.Tld12MetaData;
import org.jboss.metadata.web.spec.Tld20MetaData;
import org.jboss.metadata.web.spec.Tld21MetaData;
import org.jboss.metadata.web.spec.TldExtensionMetaData;
import org.jboss.metadata.web.spec.TldMetaData;

public class TldMetaDataParser
extends MetaDataElementParser {
    public static TldMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        int i;
        int count;
        reader.require(7, null, null);
        Version version = null;
        while (reader.hasNext() && reader.next() != 1) {
            if (reader.getEventType() != 11) continue;
            String dtdLocation = TldMetaDataParser.readDTDLocation(reader);
            if (dtdLocation != null) {
                version = Location.getVersion(dtdLocation);
            }
            if (version != null) continue;
            version = Version.TLD_1_2;
        }
        String schemaLocation = TldMetaDataParser.readSchemaLocation(reader);
        if (schemaLocation != null) {
            version = Location.getVersion(schemaLocation);
        }
        if (version == null) {
            String versionString = null;
            count = reader.getAttributeCount();
            for (i = 0; i < count; ++i) {
                Attribute attribute;
                if (reader.getAttributeNamespace(i) != null || (attribute = Attribute.forName(reader.getAttributeLocalName(i))) != Attribute.VERSION) continue;
                versionString = reader.getAttributeValue(i);
            }
            if ("2.0".equals(versionString)) {
                version = Version.TLD_2_0;
            } else if ("2.1".equals(versionString)) {
                version = Version.TLD_2_1;
            }
        }
        if (version == null) {
            version = Version.TLD_2_1;
        }
        Tld11MetaData tld = null;
        switch (version) {
            case TLD_1_1: {
                tld = new Tld11MetaData();
                break;
            }
            case TLD_1_2: {
                tld = new Tld12MetaData();
                break;
            }
            case TLD_2_0: {
                tld = new Tld20MetaData();
                break;
            }
            case TLD_2_1: {
                tld = new Tld21MetaData();
            }
        }
        count = reader.getAttributeCount();
        block28: for (i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    tld.setId(value);
                    continue block28;
                }
                case VERSION: {
                    tld.setVersion(value);
                    continue block28;
                }
                default: {
                    throw TldMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        block29: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionGroupMetaDataParser.parse(reader, descriptionGroup)) {
                if (tld.getDescriptionGroup() != null) continue;
                tld.setDescriptionGroup(descriptionGroup);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TLIB_VERSION: {
                    tld.setTlibVersion(reader.getElementText());
                    continue block29;
                }
                case TLIBVERSION: {
                    if (version == Version.TLD_1_1) {
                        tld.setTlibVersion(reader.getElementText());
                        continue block29;
                    }
                    throw TldMetaDataParser.unexpectedElement(reader);
                }
                case SHORT_NAME: {
                    tld.setShortName(reader.getElementText());
                    continue block29;
                }
                case SHORTNAME: {
                    if (version == Version.TLD_1_1) {
                        tld.setShortName(reader.getElementText());
                        continue block29;
                    }
                    throw TldMetaDataParser.unexpectedElement(reader);
                }
                case JSPVERSION: {
                    if (version == Version.TLD_1_1) {
                        tld.setJspVersion(reader.getElementText());
                        continue block29;
                    }
                    throw TldMetaDataParser.unexpectedElement(reader);
                }
                case JSP_VERSION: {
                    if (version == Version.TLD_1_2) {
                        tld.setJspVersion(reader.getElementText());
                        continue block29;
                    }
                    if (version != Version.TLD_1_1) {
                        tld.setJspVersion(reader.getElementText());
                        continue block29;
                    }
                    throw TldMetaDataParser.unexpectedElement(reader);
                }
                case INFO: {
                    if (version == Version.TLD_1_1) {
                        tld.setInfo(reader.getElementText());
                        continue block29;
                    }
                    throw TldMetaDataParser.unexpectedElement(reader);
                }
                case URI: {
                    tld.setUri(reader.getElementText());
                    continue block29;
                }
                case VALIDATOR: {
                    tld.setValidator(ValidatorMetaDataParser.parse(reader));
                    continue block29;
                }
                case LISTENER: {
                    ArrayList<ListenerMetaData> listeners = tld.getListeners();
                    if (listeners == null) {
                        listeners = new ArrayList<ListenerMetaData>();
                        tld.setListeners(listeners);
                    }
                    listeners.add(ListenerMetaDataParser.parse(reader));
                    continue block29;
                }
                case TAG: {
                    ArrayList<TagMetaData> tags = tld.getTags();
                    if (tags == null) {
                        tags = new ArrayList<TagMetaData>();
                        tld.setTags(tags);
                    }
                    tags.add(TagMetaDataParser.parse(reader, version));
                    continue block29;
                }
                case TAG_FILE: {
                    ArrayList<TagFileMetaData> tagfiles = tld.getTagFiles();
                    if (tagfiles == null) {
                        tagfiles = new ArrayList<TagFileMetaData>();
                        tld.setTagFiles(tagfiles);
                    }
                    tagfiles.add(TagFileMetaDataParser.parse(reader));
                    continue block29;
                }
                case FUNCTION: {
                    ArrayList<FunctionMetaData> functions = tld.getFunctions();
                    if (functions == null) {
                        functions = new ArrayList<FunctionMetaData>();
                        tld.setFunctions(functions);
                    }
                    functions.add(FunctionMetaDataParser.parse(reader));
                    continue block29;
                }
                case TAGLIB_EXTENSION: {
                    ArrayList<TldExtensionMetaData> extensions = tld.getTaglibExtensions();
                    if (extensions == null) {
                        extensions = new ArrayList<TldExtensionMetaData>();
                        tld.setTaglibExtensions(extensions);
                    }
                    extensions.add(TldExtensionMetaDataParser.parse(reader));
                    continue block29;
                }
            }
            throw TldMetaDataParser.unexpectedElement(reader);
        }
        return tld;
    }
}

