/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.servlet;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.metadata.parser.servlet.Attribute;
import org.jboss.as.metadata.parser.servlet.Element;
import org.jboss.as.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.spec.CookieConfigMetaData;

public class CookieConfigMetaDataParser
extends MetaDataElementParser {
    public static CookieConfigMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        CookieConfigMetaData cookieConfig = new CookieConfigMetaData();
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    cookieConfig.setId(value);
                    continue block14;
                }
                default: {
                    throw CookieConfigMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    cookieConfig.setName(reader.getElementText());
                    continue block15;
                }
                case DOMAIN: {
                    cookieConfig.setDomain(reader.getElementText());
                    continue block15;
                }
                case PATH: {
                    cookieConfig.setPath(reader.getElementText());
                    continue block15;
                }
                case COMMENT: {
                    cookieConfig.setComment(reader.getElementText());
                    continue block15;
                }
                case HTTP_ONLY: {
                    if (Boolean.TRUE.equals(Boolean.valueOf(reader.getElementText()))) {
                        cookieConfig.setHttpOnly(true);
                        continue block15;
                    }
                    cookieConfig.setHttpOnly(false);
                    continue block15;
                }
                case SECURE: {
                    if (Boolean.TRUE.equals(Boolean.valueOf(reader.getElementText()))) {
                        cookieConfig.setSecure(true);
                        continue block15;
                    }
                    cookieConfig.setSecure(false);
                    continue block15;
                }
                case MAX_AGE: {
                    try {
                        cookieConfig.setMaxAge(Integer.valueOf(reader.getElementText()).intValue());
                        continue block15;
                    }
                    catch (NumberFormatException e) {
                        throw CookieConfigMetaDataParser.unexpectedValue(reader, e);
                    }
                }
            }
            throw CookieConfigMetaDataParser.unexpectedElement(reader);
        }
        return cookieConfig;
    }
}

