/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.services.net.SocketBinding;
import org.jboss.as.web.AbstractWebSubsystemUpdate;
import org.jboss.as.web.WebConnectorElement;
import org.jboss.as.web.WebConnectorRemove;
import org.jboss.as.web.WebConnectorService;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemElement;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class WebConnectorAdd
extends AbstractWebSubsystemUpdate<Void> {
    private static final long serialVersionUID = 8619926322146139691L;
    private final String name;
    private String protocol;
    private String bindingRef;
    private String scheme;
    private String executorRef;
    private Boolean enabled;
    private Boolean enableLookups;
    private String proxyName;
    private Integer proxyPort;
    private Integer redirectPort;
    private Boolean secure;
    private Integer maxPostSize;
    private Integer maxSavePostSize;

    public WebConnectorAdd(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null connector name");
        }
        this.name = name;
    }

    protected void applyUpdate(WebSubsystemElement element) throws UpdateFailedException {
        WebConnectorElement connector = element.addConnector(this.name);
        if (connector == null) {
            throw new UpdateFailedException("duplicate connector " + this.name);
        }
        connector.setProtocol(this.protocol);
        connector.setBindingRef(this.bindingRef);
        connector.setScheme(this.scheme);
        connector.setExecutorRef(this.executorRef);
        if (this.enabled != null) {
            connector.setEnabled(this.enabled);
        }
        if (this.secure != null) {
            connector.setSecure(this.secure);
        }
        if (this.enableLookups != null) {
            connector.setEnableLookups(this.enabled);
        }
        if (this.proxyName != null) {
            connector.setProxyName(this.proxyName);
        }
        if (this.proxyPort != null) {
            connector.setProxyPort(this.proxyPort);
        }
        if (this.redirectPort != null) {
            connector.setRedirectPort(this.redirectPort);
        }
        if (this.maxPostSize != null) {
            connector.setMaxPostSize(this.maxPostSize);
        }
        if (this.maxSavePostSize != null) {
            connector.setMaxSavePostSize(this.maxSavePostSize);
        }
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        boolean enabled = this.enabled == null || this.enabled != false;
        WebConnectorService service = new WebConnectorService(this.protocol, this.scheme);
        if (this.secure != null) {
            service.setSecure(this.secure);
        }
        if (this.enableLookups != null) {
            service.setEnableLookups(enabled);
        }
        if (this.proxyName != null) {
            service.setProxyName(this.proxyName);
        }
        if (this.proxyPort != null) {
            service.setProxyPort(this.proxyPort);
        }
        if (this.redirectPort != null) {
            service.setRedirectPort(this.redirectPort);
        }
        if (this.maxPostSize != null) {
            service.setMaxPostSize(this.maxPostSize);
        }
        if (this.maxSavePostSize != null) {
            service.setMaxSavePostSize(this.maxSavePostSize);
        }
        context.getBatchBuilder().addService(WebSubsystemElement.JBOSS_WEB_CONNECTOR.append(new String[]{this.name}), (Service)service).addDependency(WebSubsystemElement.JBOSS_WEB, WebServer.class, service.getServer()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{this.bindingRef}), SocketBinding.class, service.getBinding()).addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(resultHandler, param)).setInitialMode(enabled ? ServiceController.Mode.IMMEDIATE : ServiceController.Mode.NEVER);
    }

    public AbstractSubsystemUpdate<WebSubsystemElement, ?> getCompensatingUpdate(WebSubsystemElement original) {
        return new WebConnectorRemove(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getBindingRef() {
        return this.bindingRef;
    }

    public void setBindingRef(String bindingRef) {
        this.bindingRef = bindingRef;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getExecutorRef() {
        return this.executorRef;
    }

    public void setExecutorRef(String executorRef) {
        this.executorRef = executorRef;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    protected Boolean getEnableLookups() {
        return this.enableLookups;
    }

    protected void setEnableLookups(Boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    protected String getProxyName() {
        return this.proxyName;
    }

    protected void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    protected Integer getProxyPort() {
        return this.proxyPort;
    }

    protected void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    protected Integer getRedirectPort() {
        return this.redirectPort;
    }

    protected void setRedirectPort(Integer redirectPort) {
        this.redirectPort = redirectPort;
    }

    protected Integer getMaxPostSize() {
        return this.maxPostSize;
    }

    protected void setMaxPostSize(Integer maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    protected Integer getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    protected void setMaxSavePostSize(Integer maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
    }

    static WebConnectorAdd create(WebConnectorElement connector) {
        WebConnectorAdd action = new WebConnectorAdd(connector.getName());
        action.setBindingRef(connector.getBindingRef());
        action.setProtocol(connector.getProtocol());
        action.setScheme(connector.getScheme());
        action.setExecutorRef(connector.getExecutorRef());
        action.setEnabled(connector.isEnabled());
        action.setSecure(connector.isSecure());
        action.setEnableLookups(connector.isEnableLookups());
        action.setProxyName(connector.getProxyName());
        action.setProxyPort(connector.getProxyPort());
        action.setRedirectPort(connector.getRedirectPort());
        action.setMaxPostSize(connector.getMaxPostSize());
        action.setMaxSavePostSize(connector.getMaxSavePostSize());
        return action;
    }
}

