/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.web.Attribute;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class WebConnectorElement
extends AbstractModelElement<WebConnectorElement> {
    private static final long serialVersionUID = 4884228320917906019L;
    private final String name;
    private String protocol;
    private String socketBinding;
    private String scheme;
    private String executorRef;
    private Boolean enabled;
    private Boolean enableLookups;
    private String proxyName;
    private Integer proxyPort;
    private Integer redirectPort;
    private Boolean secure;
    private Integer maxPostSize;
    private Integer maxSavePostSize;

    protected WebConnectorElement(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null connector name");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getBindingRef() {
        return this.socketBinding;
    }

    void setBindingRef(String bindingRef) {
        this.socketBinding = bindingRef;
    }

    public String getExecutorRef() {
        return this.executorRef;
    }

    void setExecutorRef(String executorRef) {
        this.executorRef = executorRef;
    }

    public String getScheme() {
        return this.scheme;
    }

    void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean isSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public Boolean isEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(Boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Integer getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(Integer redirectPort) {
        this.redirectPort = redirectPort;
    }

    public Integer getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(Integer maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    public Integer getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(Integer maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    protected Class<WebConnectorElement> getElementClass() {
        return WebConnectorElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        WebConnectorElement.writeAttribute(Attribute.PROTOCOL, this.protocol, streamWriter);
        WebConnectorElement.writeAttribute(Attribute.SOCKET_BINDING, this.socketBinding, streamWriter);
        WebConnectorElement.writeAttribute(Attribute.SCHEME, this.scheme, streamWriter);
        WebConnectorElement.writeAttribute(Attribute.EXECUTOR, this.executorRef, streamWriter);
        if (this.enabled != null) {
            WebConnectorElement.writeAttribute(Attribute.ENABLED, this.enabled.toString(), streamWriter);
        }
        if (this.secure != null) {
            WebConnectorElement.writeAttribute(Attribute.SECURE, this.secure.toString(), streamWriter);
        }
        if (this.enableLookups != null) {
            WebConnectorElement.writeAttribute(Attribute.ENABLE_LOOKUPS, this.enableLookups.toString(), streamWriter);
        }
        WebConnectorElement.writeAttribute(Attribute.PROXY_NAME, this.proxyName, streamWriter);
        if (this.proxyPort != null) {
            WebConnectorElement.writeAttribute(Attribute.PROXY_PORT, this.proxyPort.toString(), streamWriter);
        }
        if (this.redirectPort != null) {
            WebConnectorElement.writeAttribute(Attribute.REDIRECT_PORT, this.redirectPort.toString(), streamWriter);
        }
        if (this.maxPostSize != null) {
            WebConnectorElement.writeAttribute(Attribute.MAX_POST_SIZE, this.maxPostSize.toString(), streamWriter);
        }
        if (this.maxSavePostSize != null) {
            WebConnectorElement.writeAttribute(Attribute.MAX_SAVE_POST_SIZE, this.maxSavePostSize.toString(), streamWriter);
        }
        streamWriter.writeEndElement();
    }

    static void writeAttribute(Attribute attribute, String content, XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (content != null) {
            streamWriter.writeAttribute(attribute.getLocalName(), content);
        }
    }
}

