/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Set;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.services.path.AbstractPathService;
import org.jboss.as.services.path.RelativePathService;
import org.jboss.as.web.AbstractWebSubsystemUpdate;
import org.jboss.as.web.WebHostAccessLogElement;
import org.jboss.as.web.WebHostRewriteElement;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemElement;
import org.jboss.as.web.WebVirtualHostElement;
import org.jboss.as.web.WebVirtualHostRemove;
import org.jboss.as.web.WebVirtualHostService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public class WebVirtualHostAdd
extends AbstractWebSubsystemUpdate<Void> {
    private static final long serialVersionUID = 727085265030986640L;
    private static final String TEMP_DIR = "jboss.server.temp.dir";
    private final String name;
    private Set<String> aliases;
    private WebHostAccessLogElement accessLog;
    private WebHostRewriteElement rewrite;
    static final String DEFAULT_RELATIVE_TO = "jboss.server.log.dir";

    public WebVirtualHostAdd(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null host name");
        }
        this.name = name;
    }

    protected void applyUpdate(WebSubsystemElement element) throws UpdateFailedException {
        WebVirtualHostElement host = element.addHost(this.name);
        if (host == null) {
            throw new IllegalStateException("duplicate host " + this.name);
        }
        host.setAliases(this.aliases);
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        BatchBuilder builder = updateContext.getBatchBuilder();
        WebVirtualHostService service = new WebVirtualHostService(this.name, this.aliases());
        BatchServiceBuilder serviceBuilder = builder.addService(WebSubsystemElement.JBOSS_WEB_HOST.append(new String[]{this.name}), (Service)service).addDependency(AbstractPathService.pathNameOf((String)TEMP_DIR), String.class, service.getTempPathInjector()).addDependency(WebSubsystemElement.JBOSS_WEB, WebServer.class, service.getWebServer());
        if (this.accessLog != null) {
            service.setAccessLog(this.accessLog);
            WebVirtualHostAdd.accessLogService(this.name, this.accessLog.getDirectory(), builder);
            serviceBuilder.addDependency(WebSubsystemElement.JBOSS_WEB_HOST.append(new String[]{this.name, "access-log"}), String.class, service.getAccessLogPathInjector());
        }
        if (this.rewrite != null) {
            service.setRewrite(this.rewrite);
        }
    }

    public AbstractSubsystemUpdate<WebSubsystemElement, ?> getCompensatingUpdate(WebSubsystemElement original) {
        return new WebVirtualHostRemove(this.name);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Set<String> aliases) {
        this.aliases = aliases;
    }

    public WebHostAccessLogElement getAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(WebHostAccessLogElement accessLog) {
        this.accessLog = accessLog;
    }

    public WebHostRewriteElement getRewrite() {
        return this.rewrite;
    }

    public void setRewrite(WebHostRewriteElement rewrite) {
        this.rewrite = rewrite;
    }

    private String[] aliases() {
        if (this.aliases != null && !this.aliases.isEmpty()) {
            return this.aliases.toArray(new String[this.aliases.size()]);
        }
        return new String[0];
    }

    static WebVirtualHostAdd create(WebVirtualHostElement host) {
        WebVirtualHostAdd action = new WebVirtualHostAdd(host.getName());
        action.setAliases(host.getAliases());
        action.setAccessLog(host.getAccessLog());
        action.setRewrite(host.getRewrite());
        return action;
    }

    static void accessLogService(String hostName, WebHostAccessLogElement.LogDirectory directory, BatchBuilder batchBuilder) {
        if (directory == null) {
            RelativePathService.addService((ServiceName)WebSubsystemElement.JBOSS_WEB_HOST.append(new String[]{hostName, "access-log"}), (String)hostName, (String)DEFAULT_RELATIVE_TO, (BatchBuilder)batchBuilder);
        } else {
            String relativeTo = directory.getRelativeTo() != null ? directory.getRelativeTo() : DEFAULT_RELATIVE_TO;
            String path = directory.getPath() != null ? directory.getPath() : hostName;
            RelativePathService.addService((ServiceName)WebSubsystemElement.JBOSS_WEB_HOST.append(new String[]{hostName, "access-log"}), (String)path, (String)relativeTo, (BatchBuilder)batchBuilder);
        }
    }
}

