/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.module.ModuleDeploymentProcessor;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.web.WebSubsystemElement;
import org.jboss.as.web.deployment.JBossContextConfig;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.deployment.WebContextInjector;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.as.web.deployment.WebDeploymentService;
import org.jboss.as.web.deployment.WebInjectionContainer;
import org.jboss.as.web.deployment.mock.MemoryRealm;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.vfs.VirtualFile;

public class WarDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.INSTALL_SERVICES.plus(300L);
    private final String defaultHost;

    public WarDeploymentProcessor(String defaultHost) {
        if (defaultHost == null) {
            throw new IllegalArgumentException("null default host");
        }
        this.defaultHost = defaultHost;
    }

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        WarMetaData metaData = (WarMetaData)context.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (metaData == null) {
            return;
        }
        Collection<Object> hostNames = metaData.getMergedJBossWebMetaData().getVirtualHosts();
        if (hostNames == null || hostNames.isEmpty()) {
            hostNames = Collections.singleton(this.defaultHost);
        }
        for (String hostName : hostNames) {
            if (hostName == null) {
                throw new IllegalStateException("null host name");
            }
            this.processDeployment(hostName, metaData, context);
        }
    }

    protected void processDeployment(String hostName, WarMetaData warMetaData, DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
        Module module = (Module)context.getAttachment(ModuleDeploymentProcessor.MODULE_ATTACHMENT_KEY);
        if (module == null) {
            throw new DeploymentUnitProcessingException("failed to resolve module for deployment " + deploymentRoot);
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
        StandardContext webContext = new StandardContext();
        JBossContextConfig config = new JBossContextConfig(context);
        try {
            webContext.setDocBase(deploymentRoot.getPhysicalFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        webContext.addLifecycleListener((LifecycleListener)config);
        String deploymentName = context.getName();
        String pathName = null;
        if (metaData.getContextRoot() == null) {
            pathName = deploymentRoot.getName();
            pathName = pathName.equals("ROOT.war") ? "" : "/" + pathName.substring(0, pathName.length() - 4);
        } else {
            pathName = metaData.getContextRoot();
            if ("/".equals(pathName)) {
                pathName = "";
            }
        }
        webContext.setPath(pathName);
        webContext.setIgnoreAnnotations(true);
        MemoryRealm realm = new MemoryRealm();
        webContext.setRealm((Realm)realm);
        WebCtxLoader loader = new WebCtxLoader((ClassLoader)classLoader);
        WebInjectionContainer manager = new WebInjectionContainer((ClassLoader)classLoader);
        webContext.setInstanceManager((InstanceManager)manager);
        webContext.setLoader((Loader)loader);
        switch (metaData.getSessionCookies()) {
            case 1: {
                webContext.setCookies(true);
                break;
            }
            case 2: {
                webContext.setCookies(false);
            }
        }
        String metaDataSecurityDomain = metaData.getSecurityDomain();
        if (metaDataSecurityDomain != null) {
            metaDataSecurityDomain = metaDataSecurityDomain.trim();
        }
        BatchBuilder builder = context.getBatchBuilder();
        builder.addService(WebSubsystemElement.JBOSS_WEB.append(new String[]{deploymentName}), (Service)new WebDeploymentService(webContext)).addDependency(WebSubsystemElement.JBOSS_WEB_HOST.append(new String[]{hostName}), Host.class, (Injector)new WebContextInjector((Context)webContext)).setInitialMode(ServiceController.Mode.ACTIVE);
    }
}

