/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.metadata.parser.servlet.WebMetaDataParser;
import org.jboss.as.metadata.parser.util.NoopXmlResolver;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.vfs.VirtualFile;

public class WebParsingDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.PARSE_DESCRIPTORS.plus(300L);
    private static final String WEB_XML = "WEB-INF/web.xml";

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
        VirtualFile webXml = deploymentRoot.getChild(WEB_XML);
        WarMetaData warMetaData = (WarMetaData)context.getAttachment(WarMetaData.ATTACHMENT_KEY);
        assert (warMetaData != null);
        if (webXml.exists()) {
            InputStream is = null;
            try {
                is = webXml.openStream();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setXMLResolver(NoopXmlResolver.create());
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
                warMetaData.setWebMetaData(WebMetaDataParser.parse(xmlReader));
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to parse " + webXml, (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }
}

