/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.web.WebConnectorAdd;
import org.jboss.as.web.WebSubsystemDescriptions;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class WebConnectorRemove
implements ModelRemoveOperationHandler,
DescriptionProvider {
    static final WebConnectorRemove INSTANCE = new WebConnectorRemove();

    private WebConnectorRemove() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        ModelNode subModel = context.getSubModel();
        ModelNode compensatingOperation = WebConnectorAdd.getRecreateOperation(opAddr, subModel);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController service = context.getServiceRegistry().getService(WebSubsystemServices.JBOSS_WEB_CONNECTOR.append(new String[]{name}));
                    if (service != null) {
                        service.addListener((ServiceListener)new ResultHandler.ServiceRemoveListener(resultHandler));
                    } else {
                        resultHandler.handleResultComplete();
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    public ModelNode getModelDescription(Locale locale) {
        return WebSubsystemDescriptions.getConnectorRemove(locale);
    }
}

