/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import javax.management.MBeanServer;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ServiceMapperListener;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.startup.Catalina;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.as.web.WebServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class WebServerService
implements WebServer,
Service<WebServer> {
    private static final String JBOSS_WEB = "jboss.web";
    private final String defaultHost;
    private Engine engine;
    private Catalina catalina;
    private StandardService service;
    private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
    private final InjectedValue<String> pathInjector = new InjectedValue();

    public WebServerService(String defaultHost) {
        this.defaultHost = defaultHost != null ? defaultHost : "localhost";
    }

    public synchronized void start(StartContext context) throws StartException {
        MBeanServer mbeanServer;
        if (Constants.ENABLE_MODELER && (mbeanServer = (MBeanServer)this.mbeanServer.getOptionalValue()) != null) {
            this.getRegistry().setMBeanServer(mbeanServer);
        }
        Catalina catalina = new Catalina();
        catalina.setCatalinaHome((String)this.pathInjector.getValue());
        StandardServer server = new StandardServer();
        catalina.setServer((Server)server);
        StandardService service = new StandardService();
        service.setName(JBOSS_WEB);
        service.setServer((Server)server);
        server.addService((org.apache.catalina.Service)service);
        StandardEngine engine = new StandardEngine();
        engine.setName(JBOSS_WEB);
        engine.setService((org.apache.catalina.Service)service);
        engine.setDefaultHost(this.defaultHost);
        service.setContainer((Container)engine);
        try {
            catalina.create();
            server.initialize();
            catalina.start();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        this.catalina = catalina;
        this.service = service;
        this.engine = engine;
    }

    public synchronized void stop(StopContext context) {
        this.catalina.stop();
        this.catalina.destroy();
        this.engine = null;
        this.service = null;
        this.catalina = null;
    }

    public synchronized WebServer getValue() throws IllegalStateException {
        return this;
    }

    @Override
    public synchronized void addConnector(Connector connector) {
        StandardService service = this.service;
        service.addConnector(connector);
    }

    @Override
    public synchronized void removeConnector(Connector connector) {
        StandardService service = this.service;
        service.removeConnector(connector);
    }

    @Override
    public synchronized void addHost(Host host) {
        Engine engine = this.engine;
        engine.addChild((Container)host);
        for (LifecycleListener listener : this.service.findLifecycleListeners()) {
            if (!(listener instanceof ServiceMapperListener)) continue;
            host.addContainerListener((ContainerListener)((ServiceMapperListener)listener));
        }
    }

    @Override
    public synchronized void removeHost(Host host) {
        Engine engine = this.engine;
        engine.removeChild((Container)host);
        for (LifecycleListener listener : this.service.findLifecycleListeners()) {
            if (!(listener instanceof ServiceMapperListener)) continue;
            host.removeContainerListener((ContainerListener)((ServiceMapperListener)listener));
        }
    }

    InjectedValue<MBeanServer> getMbeanServer() {
        return this.mbeanServer;
    }

    InjectedValue<String> getPathInjector() {
        return this.pathInjector;
    }

    Registry getRegistry() {
        return Registry.getRegistry(null, null);
    }
}

