/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.apache.catalina.Host;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.valves.AccessLogValve;
import org.jboss.as.web.WebServer;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.web.rewrite.RewriteValve;

class WebVirtualHostService
implements Service<Host> {
    private final String name;
    private final String[] aliases;
    private ModelNode accessLog;
    private ModelNode rewrite;
    private final InjectedValue<String> tempPathInjector = new InjectedValue();
    private final InjectedValue<String> accessLogPathInjector = new InjectedValue();
    private final InjectedValue<WebServer> webServer = new InjectedValue();
    private Host host;

    public WebVirtualHostService(String name, String[] aliases) {
        this.name = name;
        this.aliases = aliases;
    }

    public synchronized void start(StartContext context) throws StartException {
        StandardHost host = new StandardHost();
        host.setAppBase((String)this.tempPathInjector.getValue());
        host.setName(this.name);
        for (String alias : this.aliases) {
            host.addAlias(alias);
        }
        if (this.accessLog != null) {
            host.addValve(WebVirtualHostService.createAccessLogValve((String)this.accessLogPathInjector.getValue(), this.accessLog));
        }
        if (this.rewrite != null) {
            host.addValve(WebVirtualHostService.createRewriteValve(this.rewrite));
        }
        try {
            WebServer server = (WebServer)this.webServer.getValue();
            server.addHost((Host)host);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        this.host = host;
    }

    public synchronized void stop(StopContext context) {
        Host host = this.host;
        this.host = null;
        WebServer server = (WebServer)this.webServer.getValue();
        server.removeHost(host);
    }

    public synchronized Host getValue() throws IllegalStateException {
        Host host = this.host;
        if (host == null) {
            throw new IllegalStateException();
        }
        return host;
    }

    void setAccessLog(ModelNode accessLog) {
        this.accessLog = accessLog;
    }

    void setRewrite(ModelNode rewrite) {
        this.rewrite = rewrite;
    }

    InjectedValue<String> getAccessLogPathInjector() {
        return this.accessLogPathInjector;
    }

    InjectedValue<String> getTempPathInjector() {
        return this.tempPathInjector;
    }

    InjectedValue<WebServer> getWebServer() {
        return this.webServer;
    }

    static Valve createAccessLogValve(String logDirectory, ModelNode element) {
        AccessLogValve log = new AccessLogValve();
        log.setDirectory(logDirectory);
        log.setResolveHosts(element.get("resolve-hosts").asBoolean());
        log.setRotatable(element.get("rotate").asBoolean());
        log.setPattern(element.get("pattern").asString());
        log.setPrefix(element.get("prefix").asString());
        return log;
    }

    static Valve createRewriteValve(ModelNode element) {
        RewriteValve rewrite = new RewriteValve();
        return rewrite;
    }
}

