/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.web.deployment.component.ComponentInstantiator;
import org.jboss.msc.service.ServiceName;

public class WebInjectionContainer
implements InstanceManager {
    private final ClassLoader classloader;
    private final Map<String, ComponentInstantiator> webComponentInstantiatorMap = new HashMap<String, ComponentInstantiator>();
    private final Set<ServiceName> serviceNames = new HashSet<ServiceName>();
    private final Map<Object, ManagedReference> instanceMap = Collections.synchronizedMap(new IdentityHashMap());

    public WebInjectionContainer(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public void addInstantiator(String className, ComponentInstantiator instantiator) {
        this.webComponentInstantiatorMap.put(className, instantiator);
        this.serviceNames.addAll(instantiator.getServiceNames());
    }

    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        ManagedReference reference = this.instanceMap.get(instance);
        if (reference != null) {
            reference.release();
            this.instanceMap.remove(instance);
        }
    }

    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        return this.newInstance(this.classloader.loadClass(className));
    }

    public Object newInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
        ComponentInstantiator instantiator = this.webComponentInstantiatorMap.get(clazz.getName());
        if (instantiator != null) {
            return this.instantiate(instantiator);
        }
        Object object = clazz.newInstance();
        this.newInstance(object);
        return object;
    }

    public void newInstance(Object arg0) throws IllegalAccessException, InvocationTargetException, NamingException {
    }

    public Object newInstance(String className, ClassLoader cl) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        ComponentInstantiator instantiator = this.webComponentInstantiatorMap.get(className);
        if (instantiator != null) {
            return this.instantiate(instantiator);
        }
        Class<?> clazz = cl.loadClass(className);
        return clazz.newInstance();
    }

    private Object instantiate(ComponentInstantiator instantiator) {
        ManagedReference reference = instantiator.getReference();
        this.instanceMap.put(reference.getInstance(), reference);
        return reference.getInstance();
    }

    public Set<ServiceName> getServiceNames() {
        return Collections.unmodifiableSet(this.serviceNames);
    }
}

