/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.apache.catalina.connector.Connector;
import org.apache.coyote.RequestGroupInfo;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class WebConnectorMetrics
implements ModelQueryOperationHandler {
    static WebConnectorMetrics INSTANCE = new WebConnectorMetrics();
    static final String[] NO_LOCATION = new String[0];
    private static final String BYTES_SENT = "bytesSent";
    private static final String BYTES_RECEIVED = "bytesReceived";
    private static final String PROCESSING_TIME = "processingTime";
    private static final String ERROR_COUNT = "errorCount";
    private static final String MAX_TIME = "maxTime";
    private static final String REQUEST_COUNT = "requestCount";
    static final String[] ATTRIBUTES = new String[]{"bytesSent", "bytesReceived", "processingTime", "errorCount", "maxTime", "requestCount"};

    WebConnectorMetrics() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String name = address.getLastElement().getValue();
                    String attributeName = operation.require("name").asString();
                    ServiceController controller = context.getServiceRegistry().getService(WebSubsystemServices.JBOSS_WEB_CONNECTOR.append(new String[]{name}));
                    if (controller != null) {
                        try {
                            Connector connector = (Connector)controller.getValue();
                            ModelNode result = new ModelNode();
                            if (connector.getProtocolHandler() != null && connector.getProtocolHandler().getRequestGroupInfo() != null) {
                                RequestGroupInfo info = connector.getProtocolHandler().getRequestGroupInfo();
                                if (WebConnectorMetrics.BYTES_SENT.equals(attributeName)) {
                                    result.set("" + info.getBytesSent());
                                } else if (WebConnectorMetrics.BYTES_RECEIVED.equals(attributeName)) {
                                    result.set("" + info.getBytesReceived());
                                } else if (WebConnectorMetrics.PROCESSING_TIME.equals(attributeName)) {
                                    result.set("" + info.getProcessingTime());
                                } else if (WebConnectorMetrics.ERROR_COUNT.equals(attributeName)) {
                                    result.set("" + info.getErrorCount());
                                } else if (WebConnectorMetrics.MAX_TIME.equals(attributeName)) {
                                    result.set("" + info.getMaxTime());
                                } else if (WebConnectorMetrics.REQUEST_COUNT.equals(attributeName)) {
                                    result.set("" + info.getRequestCount());
                                }
                            }
                            resultHandler.handleResultFragment(new String[0], result);
                            resultHandler.handleResultComplete();
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(new ModelNode().set("failed to get metrics" + e.getMessage()));
                        }
                    }
                }
            });
        } else {
            resultHandler.handleResultFragment(NO_LOCATION, new ModelNode().set("no metrics available"));
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult();
    }
}

