/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.concurrent.Executor;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.Http11AprProtocol;
import org.apache.coyote.http11.Http11Protocol;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.as.web.WebServer;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class WebConnectorService
implements Service<Connector> {
    private String protocol = "HTTP/1.1";
    private String scheme = "http";
    private Boolean enableLookups = null;
    private String proxyName = null;
    private Integer proxyPort = null;
    private Integer redirectPort = null;
    private Boolean secure = null;
    private Integer maxPostSize = null;
    private Integer maxSavePostSize = null;
    private Integer maxConnections = null;
    private ModelNode ssl;
    private ModelNode virtualServers;
    private Connector connector;
    private final InjectedValue<Executor> executor = new InjectedValue();
    private final InjectedValue<SocketBinding> binding = new InjectedValue();
    private final InjectedValue<WebServer> server = new InjectedValue();

    public WebConnectorService(String protocol, String scheme) {
        if (protocol != null) {
            this.protocol = protocol;
        }
        if (scheme != null) {
            this.scheme = scheme;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void start(StartContext context) throws StartException {
        binding = (SocketBinding)this.binding.getValue();
        address = binding.getSocketAddress();
        executor = (Executor)this.executor.getOptionalValue();
        try {
            connector = new Connector(this.protocol);
            connector.setPort(address.getPort());
            connector.setScheme(this.scheme);
            if (this.enableLookups != null) {
                connector.setEnableLookups(this.enableLookups.booleanValue());
            }
            if (this.maxPostSize != null) {
                connector.setMaxPostSize(this.maxPostSize.intValue());
            }
            if (this.maxSavePostSize != null) {
                connector.setMaxSavePostSize(this.maxSavePostSize.intValue());
            }
            if (this.proxyName != null) {
                connector.setProxyName(this.proxyName);
            }
            if (this.proxyPort != null) {
                connector.setProxyPort(this.proxyPort.intValue());
            }
            if (this.redirectPort != null) {
                connector.setRedirectPort(this.redirectPort.intValue());
            }
            if (this.secure != null) {
                connector.setSecure(this.secure.booleanValue());
            }
            if (executor != null) {
                m = connector.getProtocolHandler().getClass().getMethod("setExecutor", new Class[]{Executor.class});
                m.invoke((Object)connector.getProtocolHandler(), new Object[]{executor});
            }
            if (address != null && address.getAddress() != null) {
                m = connector.getProtocolHandler().getClass().getMethod("setAddress", new Class[]{InetAddress.class});
                m.invoke((Object)connector.getProtocolHandler(), new Object[]{address.getAddress()});
            }
            if (this.maxConnections != null) {
                try {
                    m = connector.getProtocolHandler().getClass().getMethod("setPollerSize", new Class[]{Integer.TYPE});
                    m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.maxConnections});
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                try {
                    m = connector.getProtocolHandler().getClass().getMethod("setSendfileSize", new Class[]{Integer.TYPE});
                    m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.maxConnections});
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (this.virtualServers != null) {
                virtualServersList = new HashSet<String>();
                for (ModelNode virtualServer : this.virtualServers.asList()) {
                    virtualServersList.add(virtualServer.asString());
                }
                connector.setAllowedHosts(virtualServersList);
            }
            if (this.ssl != null) {
                nativeSSL = false;
                if (connector.getProtocolHandler() instanceof Http11AprProtocol) {
                    nativeSSL = true;
                } else if (!(connector.getProtocolHandler() instanceof Http11Protocol)) {
                    throw new StartException("Non HTTP connectors dor not support SSL");
                }
                try {
                    m = connector.getProtocolHandler().getClass().getMethod("setSSLEnabled", new Class[]{Boolean.TYPE});
                    m.invoke((Object)connector.getProtocolHandler(), new Object[]{true});
                }
                catch (NoSuchMethodException e) {
                    throw new StartException((Throwable)e);
                }
                if (nativeSSL) {
                    try {
                        if (this.ssl.hasDefined("password")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLPassword", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("password").asString()});
                        }
                        if (this.ssl.hasDefined("certificate-key-file")) {
                            certificateKeyFiles = this.ssl.get("certificate-key-file").asString();
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCertificateKeyFile", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{certificateKeyFiles});
                        }
                        if (this.ssl.hasDefined("cipher-suite")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCipherSuite", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("cipher-suite").asString()});
                        }
                        if (this.ssl.hasDefined("protocol")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLProtocol", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("protocol").asString()});
                        }
                        if (this.ssl.hasDefined("verify-client")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLVerifyClient", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("verify-client").asString()});
                        }
                        if (this.ssl.hasDefined("verify-depth")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLVerifyDepth", new Class[]{Integer.TYPE});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("verify-depth").asInt()});
                        }
                        if (this.ssl.hasDefined("certificate-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCertificateFile", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("certificate-file").asString()});
                        }
                        if (this.ssl.hasDefined("ca-certificate-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCACertificateFile", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("ca-certificate-file").asString()});
                        }
                        if (!this.ssl.hasDefined("ca-revocation-url")) ** GOTO lbl144
                        m = connector.getProtocolHandler().getClass().getMethod("setSSLCARevocationFile", new Class[]{String.class});
                        m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("ca-revocation-url").asString()});
                    }
                    catch (NoSuchMethodException e) {
                        throw new StartException((Throwable)e);
                    }
                } else {
                    try {
                        if (this.ssl.hasDefined("key-alias")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setKeyAlias", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("key-alias").asString()});
                        }
                        if (this.ssl.hasDefined("password")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setKeypass", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("password").asString()});
                        }
                        if (this.ssl.hasDefined("certificate-key-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setKeystore", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("certificate-key-file").asString()});
                        }
                        if (this.ssl.hasDefined("cipher-suite")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setCiphers", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("cipher-suite").asString()});
                        }
                        if (this.ssl.hasDefined("protocol")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setProtocols", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("protocol").asString()});
                        }
                        if (this.ssl.hasDefined("verify-client")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setClientauth", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("verify-client").asString()});
                        }
                        if (this.ssl.hasDefined("session-cache-size")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"sessionCacheSize", this.ssl.get("session-cache-size").asString()});
                        }
                        if (this.ssl.hasDefined("session-timeout")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"sessionCacheTimeout", this.ssl.get("session-timeout").asString()});
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw new StartException((Throwable)e);
                    }
                }
            }
lbl144:
            // 5 sources

            this.getWebServer().addConnector(connector);
            this.connector = connector;
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        Connector connector = this.connector;
        this.getWebServer().removeConnector(connector);
        this.connector = null;
    }

    public synchronized Connector getValue() throws IllegalStateException {
        Connector connector = this.connector;
        if (connector == null) {
            throw new IllegalStateException();
        }
        return connector;
    }

    void setSsl(ModelNode ssl) {
        this.ssl = ssl;
    }

    void setVirtualServers(ModelNode virtualServers) {
        this.virtualServers = virtualServers;
    }

    protected boolean isEnableLookups() {
        return this.enableLookups;
    }

    protected void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    protected String getProxyName() {
        return this.proxyName;
    }

    protected void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    protected int getProxyPort() {
        return this.proxyPort;
    }

    protected void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    protected int getRedirectPort() {
        return this.redirectPort;
    }

    protected void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    protected boolean isSecure() {
        return this.secure;
    }

    protected void setSecure(boolean secure) {
        this.secure = secure;
    }

    protected int getMaxPostSize() {
        return this.maxPostSize;
    }

    protected void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    protected int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    protected void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
    }

    protected int getMaxConnections() {
        return this.maxConnections;
    }

    protected void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    InjectedValue<Executor> getExecutor() {
        return this.executor;
    }

    InjectedValue<SocketBinding> getBinding() {
        return this.binding;
    }

    InjectedValue<WebServer> getServer() {
        return this.server;
    }

    private WebServer getWebServer() {
        return (WebServer)this.server.getValue();
    }
}

