/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemDescriptions;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.WebVirtualHostService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class WebVirtualHostAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    static final WebVirtualHostAdd INSTANCE = new WebVirtualHostAdd();
    private static final String DEFAULT_RELATIVE_TO = "jboss.server.log.dir";
    private static final String TEMP_DIR = "jboss.server.temp.dir";
    private static final String[] NO_ALIASES = new String[0];

    private WebVirtualHostAdd() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("remove");
        compensatingOperation.get("address").set(operation.require("address"));
        ModelNode subModel = context.getSubModel();
        subModel.get("alias").set(operation.get("alias"));
        subModel.get("access-log").set(operation.get("access-log"));
        subModel.get("rewrite").set(operation.get("rewrite"));
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    WebVirtualHostService service = new WebVirtualHostService(name, WebVirtualHostAdd.aliases(operation));
                    ServiceBuilder serviceBuilder = serviceTarget.addService(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{name}), (Service)service).addDependency(AbstractPathService.pathNameOf((String)WebVirtualHostAdd.TEMP_DIR), String.class, service.getTempPathInjector()).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getWebServer());
                    if (operation.hasDefined("access-log")) {
                        ModelNode accessLog = operation.get("access-log");
                        service.setAccessLog(accessLog.clone());
                        WebVirtualHostAdd.accessLogService(name, accessLog, serviceTarget);
                        serviceBuilder.addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{name, "access-log"}), String.class, service.getAccessLogPathInjector());
                    }
                    if (operation.hasDefined("rewrite")) {
                        service.setRewrite(operation.get("rewrite").clone());
                    }
                    if (operation.hasDefined("default-web-module")) {
                        service.setDefaultWebModule(operation.get("default-web-module").asString());
                    }
                    serviceBuilder.addListener((ServiceListener)new ResultHandler.ServiceStartListener(resultHandler));
                    serviceBuilder.install();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    static String[] aliases(ModelNode node) {
        if (node.has("alias")) {
            ModelNode aliases = node.require("alias");
            int size = aliases.asInt();
            String[] array = new String[size];
            for (int i = 0; i < size; ++i) {
                array[i] = aliases.get(i).asString();
            }
            return array;
        }
        return NO_ALIASES;
    }

    static void accessLogService(String hostName, ModelNode element, ServiceTarget target) {
        if (element.has("access-log")) {
            ModelNode accessLog = element.get("access-log");
            String relativeTo = accessLog.has("relative-to") ? accessLog.get("relative-to").asString() : DEFAULT_RELATIVE_TO;
            String path = accessLog.has("path") ? accessLog.get("path").asString() : hostName;
            RelativePathService.addService((ServiceName)WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{hostName, "access-log"}), (String)path, (String)relativeTo, (ServiceTarget)target);
        } else {
            RelativePathService.addService((ServiceName)WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{hostName, "access-log"}), (String)hostName, (String)DEFAULT_RELATIVE_TO, (ServiceTarget)target);
        }
    }

    static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        if (subModel.hasDefined("alias")) {
            operation.get("alias").set(subModel.get("alias"));
        }
        if (subModel.hasDefined("access-log")) {
            operation.get("access-log").set(subModel.get("access-log"));
        }
        if (subModel.hasDefined("rewrite")) {
            operation.get("rewrite").set(subModel.get("rewrite"));
        }
        return operation;
    }

    public ModelNode getModelDescription(Locale locale) {
        return WebSubsystemDescriptions.getVirtualServerAdd(locale);
    }
}

