/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class WarClassloadingDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier JAVAX_EE_API = ModuleIdentifier.create((String)"javaee.api");
    private static final ModuleIdentifier APACHE_XERCES = ModuleIdentifier.create((String)"org.apache.xerces");
    private static final ModuleIdentifier JSF_IMPL = ModuleIdentifier.create((String)"com.sun.jsf-impl");
    private static final ModuleIdentifier BEAN_VALIDATION = ModuleIdentifier.create((String)"org.hibernate.validator");
    private static final ModuleIdentifier JBOSS_WEB = ModuleIdentifier.create((String)"org.jboss.as.web");
    private static final ModuleIdentifier LOG = ModuleIdentifier.create((String)"org.jboss.logging");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, JAVAX_EE_API, false, false, false));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, APACHE_XERCES, false, false, true));
        ModuleDependency jsf = new ModuleDependency(moduleLoader, JSF_IMPL, false, false, false);
        jsf.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpecification.addDependency(jsf);
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, BEAN_VALIDATION, false, false, true));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, JBOSS_WEB, false, false, true));
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, LOG, false, false, false));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

