/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.as.web.WebConnectorService;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemDescriptions;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;

class WebConnectorAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    static final String OPERATION_NAME = "add";
    static final WebConnectorAdd INSTANCE = new WebConnectorAdd();

    static ModelNode getRecreateOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("protocol").set(existing.get("protocol"));
        op.get("socket-binding").set(existing.get("socket-binding"));
        if (existing.hasDefined("scheme")) {
            op.get("scheme").set(existing.get("scheme").asString());
        }
        if (existing.hasDefined("secure")) {
            op.get("secure").set(existing.get("secure").asBoolean());
        }
        if (existing.hasDefined("enabled")) {
            op.get("enabled").set(existing.get("enabled").asBoolean());
        }
        if (existing.hasDefined("enable-lookups")) {
            op.get("enable-lookups").set(existing.get("enable-lookups").asBoolean());
        }
        if (existing.hasDefined("executor")) {
            op.get("executor").set(existing.get("executor").asString());
        }
        if (existing.hasDefined("proxy-name")) {
            op.get("proxy-name").set(existing.get("proxy-name").asString());
        }
        if (existing.hasDefined("proxy-port")) {
            op.get("proxy-port").set(existing.get("proxy-port").asInt());
        }
        if (existing.hasDefined("redirect-por")) {
            op.get("redirect-por").set(existing.get("redirect-por").asInt());
        }
        if (existing.hasDefined("max-post-size")) {
            op.get("max-post-size").set(existing.get("max-post-size").asInt());
        }
        if (existing.hasDefined("max-save-post-size")) {
            op.get("max-save-post-size").set(existing.get("max-save-post-size").asInt());
        }
        if (existing.hasDefined("max-connections")) {
            op.get("max-connections").set(existing.get("max-connections").asInt());
        }
        op.get("virtual-server").set(existing.get("virtual-server"));
        op.get("ssl").set(existing.get("ssl"));
        return op;
    }

    private WebConnectorAdd() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        final String bindingRef = operation.require("socket-binding").asString();
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)opAddr);
        ModelNode subModel = context.getSubModel();
        subModel.get("protocol").set(operation.get("protocol"));
        subModel.get("socket-binding").set(operation.get("socket-binding"));
        if (operation.hasDefined("scheme")) {
            subModel.get("scheme").set(operation.get("scheme"));
        }
        if (operation.hasDefined("secure")) {
            subModel.get("secure").set(operation.get("secure").asBoolean());
        }
        if (operation.hasDefined("enabled")) {
            subModel.get("enabled").set(operation.get("enabled").asBoolean());
        }
        if (operation.hasDefined("enable-lookups")) {
            subModel.get("enable-lookups").set(operation.get("enable-lookups").asBoolean());
        }
        if (operation.hasDefined("executor")) {
            subModel.get("executor").set(operation.get("executor").asString());
        }
        if (operation.hasDefined("proxy-name")) {
            subModel.get("proxy-name").set(operation.get("proxy-name").asString());
        }
        if (operation.hasDefined("proxy-port")) {
            subModel.get("proxy-port").set(operation.get("proxy-port").asInt());
        }
        if (operation.hasDefined("redirect-por")) {
            subModel.get("redirect-por").set(operation.get("redirect-por").asInt());
        }
        if (operation.hasDefined("max-post-size")) {
            subModel.get("max-post-size").set(operation.get("max-post-size").asInt());
        }
        if (operation.hasDefined("max-save-post-size")) {
            subModel.get("max-save-post-size").set(operation.get("max-save-post-size").asInt());
        }
        if (operation.hasDefined("max-connections")) {
            subModel.get("max-connections").set(operation.get("max-connections").asInt());
        }
        subModel.get("virtual-server").set(operation.get("virtual-server"));
        subModel.get("ssl").set(operation.get("ssl"));
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    boolean enabled = operation.hasDefined("enabled") ? operation.get("enabled").asBoolean() : true;
                    WebConnectorService service = new WebConnectorService(operation.require("protocol").asString(), operation.get("scheme").asString());
                    if (operation.hasDefined("secure")) {
                        service.setSecure(operation.get("secure").asBoolean());
                    }
                    if (operation.hasDefined("enable-lookups")) {
                        service.setEnableLookups(operation.get("enable-lookups").asBoolean());
                    }
                    if (operation.hasDefined("proxy-name")) {
                        service.setProxyName(operation.get("proxy-name").asString());
                    }
                    if (operation.hasDefined("proxy-port")) {
                        service.setProxyPort(operation.get("proxy-port").asInt());
                    }
                    if (operation.hasDefined("redirect-por")) {
                        service.setRedirectPort(operation.get("redirect-por").asInt());
                    }
                    if (operation.hasDefined("max-post-size")) {
                        service.setMaxPostSize(operation.get("max-post-size").asInt());
                    }
                    if (operation.hasDefined("max-save-post-size")) {
                        service.setMaxSavePostSize(operation.get("max-save-post-size").asInt());
                    }
                    if (operation.hasDefined("max-connections")) {
                        service.setMaxConnections(operation.get("max-connections").asInt());
                    }
                    if (operation.hasDefined("virtual-server")) {
                        service.setVirtualServers(operation.get("virtual-server").clone());
                    }
                    if (operation.hasDefined("ssl")) {
                        service.setSsl(operation.get("ssl").clone());
                    }
                    ServiceBuilder serviceBuilder = context.getServiceTarget().addService(WebSubsystemServices.JBOSS_WEB_CONNECTOR.append(new String[]{name}), (Service)service).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getServer()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingRef}), SocketBinding.class, service.getBinding()).setInitialMode(enabled ? ServiceController.Mode.ACTIVE : ServiceController.Mode.NEVER);
                    serviceBuilder.install();
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    public ModelNode getModelDescription(Locale locale) {
        return WebSubsystemDescriptions.getConnectorAdd(locale);
    }
}

