/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Locale;
import javax.management.MBeanServer;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.as.web.SharedTldsMetaDataBuilder;
import org.jboss.as.web.SharedWebMetaDataBuilder;
import org.jboss.as.web.WebServerService;
import org.jboss.as.web.WebSubsystemDescriptions;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.EarContextRootProcessor;
import org.jboss.as.web.deployment.JBossWebParsingDeploymentProcessor;
import org.jboss.as.web.deployment.ServletContainerInitializerDeploymentProcessor;
import org.jboss.as.web.deployment.TldParsingDeploymentProcessor;
import org.jboss.as.web.deployment.WarAnnotationDeploymentProcessor;
import org.jboss.as.web.deployment.WarClassloadingDependencyProcessor;
import org.jboss.as.web.deployment.WarDeploymentInitializingProcessor;
import org.jboss.as.web.deployment.WarDeploymentProcessor;
import org.jboss.as.web.deployment.WarMetaDataProcessor;
import org.jboss.as.web.deployment.WarStructureDeploymentProcessor;
import org.jboss.as.web.deployment.WebFragmentParsingDeploymentProcessor;
import org.jboss.as.web.deployment.WebParsingDeploymentProcessor;
import org.jboss.as.web.deployment.component.WebComponentProcessor;
import org.jboss.as.web.deployment.jsf.JsfAnnotationProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class WebSubsystemAdd
implements ModelAddOperationHandler,
BootOperationHandler,
DescriptionProvider {
    static final WebSubsystemAdd INSTANCE = new WebSubsystemAdd();
    private static final String DEFAULT_VIRTUAL_SERVER = "localhost";
    private static final boolean DEFAULT_NATIVE = true;
    private static final String TEMP_DIR = "jboss.server.temp.dir";

    private WebSubsystemAdd() {
    }

    public OperationResult execute(OperationContext updateContext, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        final ModelNode config = operation.get("configuration");
        ModelNode subModel = updateContext.getSubModel();
        subModel.get("configuration").set(config);
        subModel.get("connector").setEmptyObject();
        subModel.get("virtual-server").setEmptyObject();
        if (updateContext instanceof BootOperationContext) {
            final BootOperationContext ctx = (BootOperationContext)updateContext;
            updateContext.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    String defaultVirtualServer = operation.has("default-virtual-server") ? operation.get("default-virtual-server").asString() : WebSubsystemAdd.DEFAULT_VIRTUAL_SERVER;
                    boolean useNative = operation.has("native") ? operation.get("native").asBoolean() : true;
                    try {
                        WebServerService service = new WebServerService(defaultVirtualServer, useNative);
                        context.getServiceTarget().addService(WebSubsystemServices.JBOSS_WEB, (Service)service).addDependency(AbstractPathService.pathNameOf((String)WebSubsystemAdd.TEMP_DIR), String.class, service.getPathInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, service.getMbeanServer()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                    }
                    catch (Throwable t) {
                        throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
                    }
                    SharedWebMetaDataBuilder sharedWebBuilder = new SharedWebMetaDataBuilder(config.clone());
                    SharedTldsMetaDataBuilder sharedTldsBuilder = new SharedTldsMetaDataBuilder(config.clone());
                    ctx.addDeploymentProcessor(Phase.STRUCTURE, 1024, (DeploymentUnitProcessor)new WarDeploymentInitializingProcessor());
                    ctx.addDeploymentProcessor(Phase.STRUCTURE, 1280, (DeploymentUnitProcessor)new WarStructureDeploymentProcessor(sharedWebBuilder.create(), sharedTldsBuilder.create()));
                    ctx.addDeploymentProcessor(Phase.PARSE, 2816, (DeploymentUnitProcessor)new WebParsingDeploymentProcessor());
                    ctx.addDeploymentProcessor(Phase.PARSE, 3072, (DeploymentUnitProcessor)new WebFragmentParsingDeploymentProcessor());
                    ctx.addDeploymentProcessor(Phase.PARSE, 3584, (DeploymentUnitProcessor)new JBossWebParsingDeploymentProcessor());
                    ctx.addDeploymentProcessor(Phase.PARSE, 3840, (DeploymentUnitProcessor)new TldParsingDeploymentProcessor());
                    ctx.addDeploymentProcessor(Phase.PARSE, 3328, (DeploymentUnitProcessor)new WarAnnotationDeploymentProcessor());
                    ctx.addDeploymentProcessor(Phase.PARSE, 7936, (DeploymentUnitProcessor)new WebComponentProcessor());
                    ctx.addDeploymentProcessor(Phase.PARSE, 4096, (DeploymentUnitProcessor)new EarContextRootProcessor());
                    ctx.addDeploymentProcessor(Phase.PARSE, 8192, (DeploymentUnitProcessor)new WarMetaDataProcessor());
                    ctx.addDeploymentProcessor(Phase.DEPENDENCIES, 1536, (DeploymentUnitProcessor)new WarClassloadingDependencyProcessor());
                    ctx.addDeploymentProcessor(Phase.INSTALL, 4864, (DeploymentUnitProcessor)new ServletContainerInitializerDeploymentProcessor());
                    ctx.addDeploymentProcessor(Phase.INSTALL, 5632, (DeploymentUnitProcessor)new JsfAnnotationProcessor());
                    ctx.addDeploymentProcessor(Phase.INSTALL, 7424, (DeploymentUnitProcessor)new WarDeploymentProcessor(defaultVirtualServer));
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("remove");
        compensatingOperation.get("address").set(operation.require("address"));
        return new BasicOperationResult(compensatingOperation);
    }

    public ModelNode getModelDescription(Locale locale) {
        return WebSubsystemDescriptions.getSubsystemAddDescription(locale);
    }
}

