/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment.component;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.deployment.component.ComponentInstantiator;
import org.jboss.as.web.deployment.component.WebComponent;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class WebComponentInstantiator
implements ComponentInstantiator {
    private volatile WebComponent component;
    private final ServiceRegistry serviceRegistry;
    private final ServiceName serviceName;

    public WebComponentInstantiator(DeploymentUnit deploymentUnit, AbstractComponentDescription componentDescription) {
        this.serviceName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{componentDescription.getComponentName()}).append(new String[]{"START"});
        this.serviceRegistry = deploymentUnit.getServiceRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedReference getReference() {
        if (this.component == null) {
            WebComponentInstantiator webComponentInstantiator = this;
            synchronized (webComponentInstantiator) {
                if (this.component == null) {
                    this.component = (WebComponent)((Object)this.serviceRegistry.getRequiredService(this.serviceName).getValue());
                }
            }
        }
        return new ManagedReference(){
            private final ComponentInstance instance;
            private boolean destroyed;
            {
                this.instance = WebComponentInstantiator.this.component.createInstance();
            }

            public synchronized void release() {
                if (!this.destroyed) {
                    this.instance.getComponent().destroyInstance(this.instance);
                    this.destroyed = true;
                }
            }

            public Object getInstance() {
                return this.instance.getInstance();
            }
        };
    }

    @Override
    public Set<ServiceName> getServiceNames() {
        return Collections.singleton(this.serviceName);
    }
}

