/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.parser.jsp.TldMetaDataParser;
import org.jboss.metadata.parser.util.NoopXmlResolver;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

class SharedTldsMetaDataBuilder {
    private static final String[] JSF_TAGLIBS = new String[]{"html_basic.tld", "jsf_core.tld", "mojarra_ext.tld"};
    private static final String[] JSTL_TAGLIBS = new String[]{"c-1_0-rt.tld", "c-1_0.tld", "c.tld", "fmt-1_0-rt.tld", "fmt-1_0.tld", "fmt.tld", "fn.tld", "permittedTaglibs.tld", "scriptfree.tld", "sql-1_0-rt.tld", "sql-1_0.tld", "sql.tld", "x-1_0-rt.tld", "x-1_0.tld", "x.tld"};
    final List<TldMetaData> tlds = new ArrayList<TldMetaData>();

    SharedTldsMetaDataBuilder(ModelNode containerConfig) {
        this.init();
    }

    private void init() {
        TldMetaData tldMetaData;
        InputStream is;
        try {
            ModuleClassLoader jsf = Module.getModuleFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.create((String)"com.sun.jsf-impl")).getClassLoader();
            for (String tld : JSF_TAGLIBS) {
                is = jsf.getResourceAsStream("META-INF/" + tld);
                if (is == null) continue;
                tldMetaData = this.parseTLD(tld, is);
                this.tlds.add(tldMetaData);
            }
        }
        catch (ModuleLoadException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ModuleClassLoader jstl = Module.getModuleFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.create((String)"javax.servlet.jstl.api")).getClassLoader();
            for (String tld : JSTL_TAGLIBS) {
                is = jstl.getResourceAsStream("META-INF/" + tld);
                if (is == null) continue;
                tldMetaData = this.parseTLD(tld, is);
                this.tlds.add(tldMetaData);
            }
        }
        catch (ModuleLoadException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    List<TldMetaData> create() {
        ArrayList<TldMetaData> metadata = new ArrayList<TldMetaData>();
        metadata.addAll(this.tlds);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldMetaData parseTLD(String tld, InputStream is) throws Exception {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXmlResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            TldMetaData tldMetaData = TldMetaDataParser.parse((XMLStreamReader)xmlReader);
            return tldMetaData;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

