/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collection;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.mgmt.domain.HttpManagement;

public class WelcomeContextConsoleServlet
extends HttpServlet {
    private static final String CONSOLE_PATH = "/console";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final int DEFAULT_PORT = 80;
    private static final int SECURE_DEFAULT_PORT = 443;
    private final boolean hasConsole;
    private final int consolePort;
    private final int consoleSecurePort;
    private final NetworkInterfaceBinding consoleNetworkInterface;
    private final String noconsole = "noconsole.html";
    private final String noredirect = "noredirect.html";

    WelcomeContextConsoleServlet(HttpManagement httpManagement) {
        if (httpManagement != null) {
            this.consolePort = httpManagement.getPort();
            this.consoleSecurePort = httpManagement.getSecurePort();
            this.consoleNetworkInterface = httpManagement.getNetworkInterfaceBinding();
            this.hasConsole = this.consolePort > -1 || this.consoleSecurePort > -1;
        } else {
            this.hasConsole = false;
            this.consolePort = -1;
            this.consoleSecurePort = -1;
            this.consoleNetworkInterface = null;
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String target = "noconsole.html";
        if (this.hasConsole) {
            InetAddress inboundAddress = InetAddress.getByName(req.getLocalAddr());
            if (this.isAccessible(inboundAddress)) {
                boolean secureRedirect = this.secureRedirect(req.isSecure());
                String host = req.getServerName();
                StringBuilder targetBuilder = new StringBuilder();
                target = secureRedirect ? this.assembleURL(HTTPS, host, this.consoleSecurePort, 443, CONSOLE_PATH) : this.assembleURL(HTTP, host, this.consolePort, 80, CONSOLE_PATH);
            } else {
                target = "noredirect.html";
            }
        }
        resp.sendRedirect(target);
    }

    private String assembleURL(String scheme, String host, int port, int defaultPort, String uri) {
        StringBuilder targetBuilder = new StringBuilder(scheme);
        targetBuilder.append(host);
        if (port != defaultPort) {
            targetBuilder.append(":");
            targetBuilder.append(port);
        }
        targetBuilder.append(uri);
        return targetBuilder.toString();
    }

    private boolean secureRedirect(boolean inboundSecure) {
        if (inboundSecure) {
            return this.consoleSecurePort > -1;
        }
        return !(this.consolePort > -1);
    }

    private boolean isAccessible(InetAddress inboundAddress) {
        Collection nics = this.consoleNetworkInterface.getNetworkInterfaces();
        for (NetworkInterface current : nics) {
            boolean matched = this.matches(current, inboundAddress);
            if (!matched) continue;
            return true;
        }
        return false;
    }

    private boolean matches(NetworkInterface nic, InetAddress match) {
        Enumeration<InetAddress> addresses = nic.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (!match.equals(address)) continue;
            return true;
        }
        Enumeration<NetworkInterface> nics = nic.getSubInterfaces();
        while (nics.hasMoreElements()) {
            NetworkInterface next = nics.nextElement();
            boolean matches = this.matches(next, match);
            if (!matches) continue;
            return true;
        }
        return false;
    }
}

