/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment.mock;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.jboss.logging.Logger;

public class MemoryRealm
extends RealmBase {
    private static Logger log = Logger.getLogger(MemoryRealm.class);
    protected final String info = "org.apache.catalina.realm.MemoryRealm/1.0";
    protected static final String name = "MemoryRealm";
    private Map<String, GenericPrincipal> principals = new HashMap<String, GenericPrincipal>();

    public String getInfo() {
        return "org.apache.catalina.realm.MemoryRealm/1.0";
    }

    public Principal authenticate(String username, String credentials) {
        GenericPrincipal principal = this.principals.get(username);
        boolean validated = false;
        if (principal != null && credentials != null) {
            validated = this.hasMessageDigest() ? this.digest(credentials).equalsIgnoreCase(principal.getPassword()) : this.digest(credentials).equals(principal.getPassword());
        }
        if (validated) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("memoryRealm.authenticateSuccess", (Object)username));
            }
            return principal;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("memoryRealm.authenticateFailure", (Object)username));
        }
        return null;
    }

    void addUser(String username, String password, String roles) {
        int comma;
        ArrayList<String> list = new ArrayList<String>();
        roles = roles + ",";
        while ((comma = roles.indexOf(44)) >= 0) {
            String role = roles.substring(0, comma).trim();
            list.add(role);
            roles = roles.substring(comma + 1);
        }
        GenericPrincipal principal = new GenericPrincipal((Realm)this, username, password, list);
        this.principals.put(username, principal);
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        GenericPrincipal principal = this.principals.get(username);
        if (principal != null) {
            return principal.getPassword();
        }
        return null;
    }

    protected Principal getPrincipal(String username) {
        return (Principal)this.principals.get(username);
    }

    protected Map<String, GenericPrincipal> getPrincipals() {
        return this.principals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws LifecycleException {
        super.start();
        Properties users = new Properties();
        Properties roles = new Properties();
        if (this.container instanceof Context) {
            ServletContext servletContext = ((Context)this.container).getServletContext();
            InputStream usersIs = null;
            InputStream rolesIs = null;
            try {
                usersIs = servletContext.getResourceAsStream("/META-INF/users.properties");
                rolesIs = servletContext.getResourceAsStream("/META-INF/roles.properties");
                if (usersIs != null) {
                    users.load(usersIs);
                }
                if (rolesIs != null) {
                    roles.load(rolesIs);
                }
                Enumeration<?> names = users.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    this.addUser(name, users.getProperty(name), roles.getProperty(name));
                }
            }
            catch (IOException e) {
            }
            finally {
                if (usersIs != null) {
                    try {
                        usersIs.close();
                    }
                    catch (IOException e) {}
                }
                if (rolesIs != null) {
                    try {
                        rolesIs.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public synchronized void stop() throws LifecycleException {
        super.stop();
    }
}

