/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.web.DefaultJspConfig;
import org.jboss.as.web.DefaultStaticResources;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class WebConfigurationHandlerUtils {
    static final PathElement JSPPATH = PathElement.pathElement((String)"configuration", (String)"jsp-configuration");
    static final PathElement RESOURCEPATH = PathElement.pathElement((String)"configuration", (String)"static-resources");
    static final PathElement CONTAINERPATH = PathElement.pathElement((String)"configuration", (String)"container");
    static final PathElement SSLPATH = PathElement.pathElement((String)"ssl", (String)"configuration");
    static final PathElement SSOPATH = PathElement.pathElement((String)"sso", (String)"configuration");
    static final PathElement REWRITEPATH = PathElement.pathElement((String)"rewrite", (String)"configuration");
    static final PathElement ACCESSLOG = PathElement.pathElement((String)"access-log", (String)"configuration");
    static final PathElement DIRECTORYPATH = PathElement.pathElement((String)"directory", (String)"configuration");
    static final PathElement REWRITECOND = PathElement.pathElement((String)"condition", (String)"configuration");

    WebConfigurationHandlerUtils() {
    }

    static void initializeConfiguration(Resource resource, ModelNode operation) {
        resource.registerChild(JSPPATH, Resource.Factory.create());
        resource.registerChild(RESOURCEPATH, Resource.Factory.create());
        resource.registerChild(CONTAINERPATH, Resource.Factory.create());
        Resource jsp = resource.getChild(JSPPATH);
        Resource resources = resource.getChild(RESOURCEPATH);
        Resource container = resource.getChild(CONTAINERPATH);
        ModelNode rootModel = resource.getModel();
        if (operation.hasDefined("default-virtual-server")) {
            rootModel.get("default-virtual-server").set(operation.get("default-virtual-server"));
        }
        if (operation.hasDefined("native")) {
            rootModel.get("native").set(operation.get("native"));
        }
        if (operation.hasDefined("instance-id")) {
            rootModel.get("instance-id").set(operation.get("instance-id"));
        }
        boolean hasJSP = false;
        boolean hasStatic = false;
        if (operation.hasDefined("configuration")) {
            for (String attribute : operation.get("configuration").keys()) {
                if (attribute.equals("jsp-configuration") && operation.get("configuration").hasDefined("jsp-configuration")) {
                    hasJSP = true;
                    WebConfigurationHandlerUtils.populateModel(jsp.getModel(), operation.get(new String[]{"configuration", "jsp-configuration"}));
                    continue;
                }
                if (attribute.equals("static-resources") && operation.get("configuration").hasDefined("static-resources")) {
                    hasStatic = true;
                    WebConfigurationHandlerUtils.populateModel(resources.getModel(), operation.get(new String[]{"configuration", "static-resources"}));
                    continue;
                }
                if (attribute.equals("mime-mapping")) {
                    container.getModel().get("mime-mapping").set(operation.get(new String[]{"configuration", "mime-mapping"}));
                    continue;
                }
                if (attribute.equals("welcome-file")) {
                    for (ModelNode file : operation.get(new String[]{"configuration", "welcome-file"}).asList()) {
                        container.getModel().get("welcome-file").add(file.asString());
                    }
                    continue;
                }
                if (!attribute.equals("container")) continue;
                ModelNode cont = operation.get(new String[]{"configuration", "container"});
                if (cont.hasDefined("mime-mapping")) {
                    container.getModel().get("mime-mapping").set(cont.get("mime-mapping"));
                }
                if (!cont.hasDefined("welcome-file")) continue;
                for (ModelNode file : cont.get("welcome-file").asList()) {
                    container.getModel().get("welcome-file").add(file.asString());
                }
            }
        }
        if (!hasJSP) {
            jsp.getModel().set(DefaultJspConfig.getDefaultStaticResource());
        }
        if (!hasStatic) {
            resources.getModel().set(DefaultStaticResources.getDefaultStaticResource());
        }
    }

    static void initializeHost(Resource resource, ModelNode operation) {
        for (String attribute : operation.keys()) {
            if (attribute.equals("rewrite") && operation.get("rewrite").isDefined()) {
                WebConfigurationHandlerUtils.populateReWrite(operation, resource);
                continue;
            }
            if (attribute.equals("access-log") && operation.get("access-log").isDefined()) {
                resource.registerChild(ACCESSLOG, Resource.Factory.create());
                Resource accesslog = resource.getChild(ACCESSLOG);
                accesslog.registerChild(DIRECTORYPATH, Resource.Factory.create());
                Resource directory = accesslog.getChild(DIRECTORYPATH);
                if (operation.get("access-log").hasDefined("configuration")) {
                    WebConfigurationHandlerUtils.populateAccessLog(accesslog.getModel(), operation.get("access-log").get("configuration"), directory);
                    continue;
                }
                WebConfigurationHandlerUtils.populateAccessLog(accesslog.getModel(), operation.get("access-log"), directory);
                continue;
            }
            if (!attribute.equals("sso") || !operation.get("sso").isDefined()) continue;
            resource.registerChild(SSOPATH, Resource.Factory.create());
            Resource sso = resource.getChild(SSOPATH);
            if (operation.get("sso").hasDefined("configuration")) {
                WebConfigurationHandlerUtils.populateModel(sso.getModel(), operation.get("sso").get("configuration"));
                continue;
            }
            WebConfigurationHandlerUtils.populateModel(sso.getModel(), operation.get("sso"));
        }
    }

    static void populateReWrite(ModelNode operation, Resource resource) {
        int num = 0;
        for (ModelNode entry : operation.get("rewrite").asList()) {
            String name = "rule-" + num++;
            PathElement rewritepath = PathElement.pathElement((String)"rewrite", (String)name);
            resource.registerChild(rewritepath, Resource.Factory.create());
            Resource rewritevalve = resource.getChild(rewritepath);
            ModelNode rule = entry.hasDefined(name) ? entry.get(name) : entry;
            for (String attribute : rule.keys()) {
                if (!rule.hasDefined(attribute)) continue;
                if (attribute.equals("condition")) {
                    int j = 0;
                    for (ModelNode cond : rule.get("condition").asList()) {
                        String condname = "condition-" + j++;
                        PathElement conditionpath = PathElement.pathElement((String)"condition", (String)condname);
                        rewritevalve.registerChild(conditionpath, Resource.Factory.create());
                        Resource condition = rewritevalve.getChild(conditionpath);
                        if (cond.hasDefined(condname)) {
                            WebConfigurationHandlerUtils.populateModel(condition.getModel(), cond.get(condname));
                            continue;
                        }
                        WebConfigurationHandlerUtils.populateModel(condition.getModel(), cond);
                    }
                    continue;
                }
                rewritevalve.getModel().get(attribute).set(rule.get(attribute));
            }
        }
    }

    static void populateAccessLog(ModelNode subModel, ModelNode operation, Resource directory) {
        for (String attribute : operation.keys()) {
            if (!operation.hasDefined(attribute)) continue;
            if (attribute.equals("directory")) {
                if (operation.get("directory").isDefined() && operation.get("directory").has("configuration")) {
                    WebConfigurationHandlerUtils.populateModel(directory.getModel(), operation.get("directory").get("configuration"));
                    continue;
                }
                WebConfigurationHandlerUtils.populateModel(directory.getModel(), operation.get("directory"));
                continue;
            }
            subModel.get(attribute).set(operation.get(attribute));
        }
    }

    static void populateModel(ModelNode subModel, ModelNode operation) {
        for (String attribute : operation.keys()) {
            if (!operation.hasDefined(attribute)) continue;
            subModel.get(attribute).set(operation.get(attribute));
        }
    }

    static void initJSPAttributes(ManagementResourceRegistration jsp) {
        jsp.registerReadWriteAttribute("development", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("disabled", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("keep-generated", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("tag-pooling", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("mapped-file", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("check-interval", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("modification-test-interval", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("recompile-on-fail", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("smap", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("dump-smap", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("generate-strings-as-char-arrays", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("error-on-use-bean-invalid-class-attribute", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("scratch-dir", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("source-vm", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("target-vm", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("java-encoding", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("x-powered-by", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        jsp.registerReadWriteAttribute("display-source-fragment", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
    }

    static void initResourcesAttribtues(ManagementResourceRegistration resources) {
        resources.registerReadWriteAttribute("listings", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        resources.registerReadWriteAttribute("sendfile", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        resources.registerReadWriteAttribute("file-encoding", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        resources.registerReadWriteAttribute("read-only", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        resources.registerReadWriteAttribute("webdav", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        resources.registerReadWriteAttribute("max-depth", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        resources.registerReadWriteAttribute("disabled", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
    }

    public static void initializeConnector(Resource resource, ModelNode model) {
        if (model.hasDefined("ssl")) {
            resource.registerChild(SSLPATH, Resource.Factory.create());
            Resource ssl = resource.getChild(SSLPATH);
            if (model.get("ssl").hasDefined("configuration")) {
                WebConfigurationHandlerUtils.populateModel(ssl.getModel(), model.get("ssl").get("configuration"));
            } else {
                WebConfigurationHandlerUtils.populateModel(ssl.getModel(), model.get("ssl"));
            }
        }
    }
}

