/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.concurrent.Executor;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.ajp.AjpAprProtocol;
import org.apache.coyote.http11.Http11AprProtocol;
import org.apache.coyote.http11.Http11Protocol;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.web.WebServer;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class WebConnectorService
implements Service<Connector> {
    private volatile String protocol = "HTTP/1.1";
    private volatile String scheme = "http";
    private final String unmaskedPassword;
    private Boolean enableLookups = null;
    private String proxyName = null;
    private Integer proxyPort = null;
    private Integer redirectPort = null;
    private Boolean secure = null;
    private Integer maxPostSize = null;
    private Integer maxSavePostSize = null;
    private Integer maxConnections = null;
    private ModelNode ssl;
    private ModelNode virtualServers;
    private Connector connector;
    private final InjectedValue<Executor> executor = new InjectedValue();
    private final InjectedValue<SocketBinding> binding = new InjectedValue();
    private final InjectedValue<WebServer> server = new InjectedValue();

    public WebConnectorService(String protocol, String scheme, String unmaskedPassword) {
        if (protocol != null) {
            this.protocol = protocol;
        }
        if (scheme != null) {
            this.scheme = scheme;
        }
        this.unmaskedPassword = unmaskedPassword;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void start(StartContext context) throws StartException {
        binding = (SocketBinding)this.binding.getValue();
        address = binding.getSocketAddress();
        executor = (Executor)this.executor.getOptionalValue();
        try {
            connector = new Connector(this.protocol);
            connector.setPort(address.getPort());
            connector.setScheme(this.scheme);
            if (this.enableLookups != null) {
                connector.setEnableLookups(this.enableLookups.booleanValue());
            }
            if (this.maxPostSize != null) {
                connector.setMaxPostSize(this.maxPostSize.intValue());
            }
            if (this.maxSavePostSize != null) {
                connector.setMaxSavePostSize(this.maxSavePostSize.intValue());
            }
            if (this.proxyName != null) {
                connector.setProxyName(this.proxyName);
            }
            if (this.proxyPort != null) {
                connector.setProxyPort(this.proxyPort.intValue());
            }
            if (this.redirectPort != null) {
                connector.setRedirectPort(this.redirectPort.intValue());
            }
            if (this.secure != null) {
                connector.setSecure(this.secure.booleanValue());
            }
            nativeProtocolHandler = false;
            if (connector.getProtocolHandler() instanceof Http11AprProtocol || connector.getProtocolHandler() instanceof AjpAprProtocol) {
                nativeProtocolHandler = true;
            }
            if (executor != null) {
                m = connector.getProtocolHandler().getClass().getMethod("setExecutor", new Class[]{Executor.class});
                m.invoke((Object)connector.getProtocolHandler(), new Object[]{executor});
            }
            if (address != null && address.getAddress() != null) {
                m = connector.getProtocolHandler().getClass().getMethod("setAddress", new Class[]{InetAddress.class});
                m.invoke((Object)connector.getProtocolHandler(), new Object[]{address.getAddress()});
            }
            if (this.maxConnections != null) {
                try {
                    m = connector.getProtocolHandler().getClass().getMethod("setPollerSize", new Class[]{Integer.TYPE});
                    m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.maxConnections});
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (nativeProtocolHandler) {
                    try {
                        m = connector.getProtocolHandler().getClass().getMethod("setSendfileSize", new Class[]{Integer.TYPE});
                        m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.maxConnections});
                    }
                    catch (NoSuchMethodException e) {}
                } else {
                    m = connector.getProtocolHandler().getClass().getMethod("setMaxThreads", new Class[]{Integer.TYPE});
                    m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.maxConnections});
                }
            }
            if (this.virtualServers != null) {
                virtualServersList = new HashSet<String>();
                for (ModelNode virtualServer : this.virtualServers.asList()) {
                    virtualServersList.add(virtualServer.asString());
                }
                connector.setAllowedHosts(virtualServersList);
            }
            if (this.ssl != null) {
                nativeSSL = false;
                if (connector.getProtocolHandler() instanceof Http11AprProtocol) {
                    nativeSSL = true;
                } else if (!(connector.getProtocolHandler() instanceof Http11Protocol)) {
                    throw new StartException("Non HTTP connectors do not support SSL");
                }
                try {
                    m = connector.getProtocolHandler().getClass().getMethod("setSSLEnabled", new Class[]{Boolean.TYPE});
                    m.invoke((Object)connector.getProtocolHandler(), new Object[]{true});
                }
                catch (NoSuchMethodException e) {
                    throw new StartException((Throwable)e);
                }
                if (nativeSSL) {
                    try {
                        if (this.ssl.hasDefined("password")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLPassword", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.unmaskedPassword});
                        }
                        if (this.ssl.hasDefined("certificate-key-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCertificateKeyFile", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("certificate-key-file").asString()});
                        }
                        if (this.ssl.hasDefined("cipher-suite")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCipherSuite", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("cipher-suite").asString()});
                        }
                        if (this.ssl.hasDefined("protocol")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLProtocol", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("protocol").asString()});
                        }
                        if (this.ssl.hasDefined("verify-client")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLVerifyClient", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("verify-client").asString()});
                        }
                        if (this.ssl.hasDefined("verify-depth")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLVerifyDepth", new Class[]{Integer.TYPE});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("verify-depth").asInt()});
                        }
                        if (this.ssl.hasDefined("certificate-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCertificateFile", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("certificate-file").asString()});
                        }
                        if (this.ssl.hasDefined("ca-certificate-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCACertificateFile", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("ca-certificate-file").asString()});
                        }
                        if (!this.ssl.hasDefined("ca-revocation-url")) ** GOTO lbl166
                        m = connector.getProtocolHandler().getClass().getMethod("setSSLCARevocationFile", new Class[]{String.class});
                        m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("ca-revocation-url").asString()});
                    }
                    catch (NoSuchMethodException e) {
                        throw new StartException((Throwable)e);
                    }
                } else {
                    try {
                        if (this.ssl.hasDefined("key-alias")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setKeyAlias", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("key-alias").asString()});
                        }
                        if (this.ssl.hasDefined("password")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setKeypass", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.unmaskedPassword});
                        }
                        if (this.ssl.hasDefined("certificate-key-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setKeystore", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("certificate-key-file").asString()});
                        }
                        if (this.ssl.hasDefined("cipher-suite")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setCiphers", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("cipher-suite").asString()});
                        }
                        if (this.ssl.hasDefined("protocol")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setProtocols", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("protocol").asString()});
                        }
                        if (this.ssl.hasDefined("verify-client")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setClientauth", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("verify-client").asString()});
                        }
                        if (this.ssl.hasDefined("session-cache-size")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"sessionCacheSize", this.ssl.get("session-cache-size").asString()});
                        }
                        if (this.ssl.hasDefined("session-timeout")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"sessionCacheTimeout", this.ssl.get("session-timeout").asString()});
                        }
                        if (this.ssl.hasDefined("ca-certificate-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"truststoreFile", this.ssl.get("ca-certificate-file").asString()});
                        }
                        if (this.ssl.hasDefined("ca-certificate-password")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"truststorePass", this.ssl.get("ca-certificate-password").asString()});
                        }
                        if (this.ssl.hasDefined("truststore-type")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"truststoreType", this.ssl.get("truststore-type").asString()});
                        }
                        if (this.ssl.hasDefined("keystore-type")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setKeytype", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("keystore-type").asString()});
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw new StartException((Throwable)e);
                    }
                }
            }
lbl166:
            // 5 sources

            this.getWebServer().addConnector(connector);
            connector.init();
            connector.start();
            this.connector = connector;
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        binding.getSocketBindings().getNamedRegistry().registerBinding((ManagedBinding)new ConnectorBinding(binding));
    }

    public synchronized void stop(StopContext context) {
        SocketBinding binding = (SocketBinding)this.binding.getValue();
        binding.getSocketBindings().getNamedRegistry().unregisterBinding(binding.getName());
        Connector connector = this.connector;
        try {
            connector.pause();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getWebServer().removeConnector(connector);
        this.connector = null;
    }

    public synchronized Connector getValue() throws IllegalStateException {
        Connector connector = this.connector;
        if (connector == null) {
            throw new IllegalStateException();
        }
        return connector;
    }

    void setSsl(ModelNode ssl) {
        this.ssl = ssl;
    }

    void setVirtualServers(ModelNode virtualServers) {
        this.virtualServers = virtualServers;
    }

    protected boolean isEnableLookups() {
        return this.enableLookups;
    }

    protected void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    protected String getProxyName() {
        return this.proxyName;
    }

    protected void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    protected int getProxyPort() {
        return this.proxyPort;
    }

    protected void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    protected int getRedirectPort() {
        return this.redirectPort;
    }

    protected void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    protected boolean isSecure() {
        return this.secure;
    }

    protected void setSecure(boolean secure) {
        this.secure = secure;
    }

    protected int getMaxPostSize() {
        return this.maxPostSize;
    }

    protected void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    protected int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    protected void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
    }

    protected int getMaxConnections() {
        return this.maxConnections;
    }

    protected void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    InjectedValue<Executor> getExecutor() {
        return this.executor;
    }

    InjectedValue<SocketBinding> getBinding() {
        return this.binding;
    }

    InjectedValue<WebServer> getServer() {
        return this.server;
    }

    private WebServer getWebServer() {
        return (WebServer)this.server.getValue();
    }

    static class ConnectorBinding
    implements ManagedBinding {
        private final SocketBinding binding;

        private ConnectorBinding(SocketBinding binding) {
            this.binding = binding;
        }

        public String getSocketBindingName() {
            return this.binding.getName();
        }

        public InetSocketAddress getBindAddress() {
            return this.binding.getSocketAddress();
        }

        public void close() throws IOException {
        }
    }
}

