/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security.jaspi;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import org.jboss.logging.Logger;

public class WebJASPICallbackHandler
implements CallbackHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.web.security");
    private CallerPrincipalCallback callerPrincipalCallback;
    private PasswordValidationCallback passwordValidationCallback;
    private GroupPrincipalCallback groupPrincipalCallback;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks.length > 0) {
            for (Callback callback : callbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    CallerPrincipalCallback callerCallback = (CallerPrincipalCallback)callback;
                    if (callerCallback.getPrincipal() != null) {
                        this.callerPrincipalCallback = new CallerPrincipalCallback(callerCallback.getSubject(), callerCallback.getPrincipal());
                        continue;
                    }
                    this.callerPrincipalCallback = new CallerPrincipalCallback(callerCallback.getSubject(), callerCallback.getName());
                    continue;
                }
                if (callback instanceof PasswordValidationCallback) {
                    PasswordValidationCallback passCallback = (PasswordValidationCallback)callback;
                    this.passwordValidationCallback = new PasswordValidationCallback(passCallback.getSubject(), passCallback.getUsername(), passCallback.getPassword());
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    GroupPrincipalCallback groupCallback = (GroupPrincipalCallback)callback;
                    this.groupPrincipalCallback = new GroupPrincipalCallback(groupCallback.getSubject(), groupCallback.getGroups());
                    continue;
                }
                log.tracef("Callback %s not supported", (Object)callback.getClass().getCanonicalName());
            }
        }
    }

    public CallerPrincipalCallback getCallerPrincipalCallback() {
        return this.callerPrincipalCallback;
    }

    public PasswordValidationCallback getPasswordValidationCallback() {
        return this.passwordValidationCallback;
    }

    public GroupPrincipalCallback getGroupPrincipalCallback() {
        return this.groupPrincipalCallback;
    }
}

