/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment.jsf;

import java.util.ArrayList;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.JsfVersionMarker;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.spec.WebFragmentMetaData;

public class JsfVersionProcessor
implements DeploymentUnitProcessor {
    public static final String JSF_CONFIG_NAME_PARAM = "org.jboss.jbossfaces.JSF_CONFIG_NAME";
    public static final String WAR_BUNDLES_JSF_IMPL_PARAM = "org.jboss.jbossfaces.WAR_BUNDLES_JSF_IMPL";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (metaData == null) {
            return;
        }
        ArrayList contextParams = new ArrayList();
        if (metaData.getWebMetaData() != null && metaData.getWebMetaData().getContextParams() != null) {
            contextParams.addAll(metaData.getWebMetaData().getContextParams());
        }
        if (metaData.getWebFragmentsMetaData() != null) {
            for (WebFragmentMetaData fragmentMetaData : metaData.getWebFragmentsMetaData().values()) {
                if (fragmentMetaData.getContextParams() == null) continue;
                contextParams.addAll(fragmentMetaData.getContextParams());
            }
        }
        for (ParamValueMetaData param : contextParams) {
            if (param.getParamName().equals(WAR_BUNDLES_JSF_IMPL_PARAM) && param.getParamValue() != null && param.getParamValue().toLowerCase().equals("true")) {
                JsfVersionMarker.setVersion(topLevelDeployment, "WAR_BUNDLES_JSF_IMPL");
                break;
            }
            if (!param.getParamName().equals(JSF_CONFIG_NAME_PARAM)) continue;
            JsfVersionMarker.setVersion(topLevelDeployment, param.getParamValue());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

