/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.List;
import org.jboss.as.clustering.web.sso.SSOClusterManager;
import org.jboss.as.clustering.web.sso.SSOClusterManagerService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebAccessLogDirectoryDefinition;
import org.jboss.as.web.WebExtension;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.WebVirtualHostDefinition;
import org.jboss.as.web.WebVirtualHostService;
import org.jboss.as.web.WelcomeContextService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class WebVirtualHostAdd
extends AbstractAddStepHandler {
    static final WebVirtualHostAdd INSTANCE = new WebVirtualHostAdd();
    private static final String DEFAULT_RELATIVE_TO = "jboss.server.log.dir";
    private static final String TEMP_DIR = "jboss.server.temp.dir";
    private static final String HOME_DIR = "jboss.home.dir";
    private static final String[] NO_ALIASES = new String[0];

    private WebVirtualHostAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        model.get(WebVirtualHostDefinition.NAME.getName()).set(address.getLastElement().getValue());
        WebVirtualHostDefinition.ALIAS.validateAndSet(operation, model);
        WebVirtualHostDefinition.ENABLE_WELCOME_ROOT.validateAndSet(operation, model);
        WebVirtualHostDefinition.DEFAULT_WEB_MODULE.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode baseOperation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode operation = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress address = PathAddress.pathAddress((ModelNode)baseOperation.require("address"));
        String name = address.getLastElement().getValue();
        boolean welcome = WebVirtualHostDefinition.ENABLE_WELCOME_ROOT.resolveModelAttribute(context, operation).asBoolean();
        ServiceTarget serviceTarget = context.getServiceTarget();
        WebVirtualHostService service = new WebVirtualHostService(name, WebVirtualHostAdd.aliases(operation), welcome, TEMP_DIR);
        ServiceBuilder serviceBuilder = serviceTarget.addService(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{name}), (Service)service).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.getPathManagerInjector()).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getWebServer());
        if (operation.get(new String[]{WebExtension.ACCESS_LOG_PATH.getKey(), WebExtension.ACCESS_LOG_PATH.getValue()}).isDefined()) {
            ModelNode accessLog = operation.get(new String[]{WebExtension.ACCESS_LOG_PATH.getKey(), WebExtension.ACCESS_LOG_PATH.getValue()});
            service.setAccessLog(accessLog.clone());
            service.setAccessLogPaths(WebVirtualHostAdd.getPath(context, accessLog, name), WebVirtualHostAdd.getRelativeTo(context, accessLog, name));
        }
        if (operation.hasDefined("rewrite")) {
            service.setRewrite(operation.get("rewrite").clone());
        }
        if (operation.get(new String[]{WebExtension.SSO_PATH.getKey(), WebExtension.SSO_PATH.getValue()}).isDefined()) {
            ModelNode sso = operation.get(new String[]{WebExtension.SSO_PATH.getKey(), WebExtension.SSO_PATH.getValue()}).clone();
            service.setSso(sso);
            if (sso.hasDefined("cache-container")) {
                ServiceName ssoName = WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{name, "sso"});
                serviceBuilder.addDependency(ssoName, SSOClusterManager.class, service.getSSOClusterManager());
                SSOClusterManagerService ssoService = new SSOClusterManagerService();
                SSOClusterManager ssoManager = ssoService.getValue();
                ssoManager.setCacheContainerName(sso.get("cache-container").asString());
                if (sso.hasDefined("cache-name")) {
                    ssoManager.setCacheName(sso.get("cache-name").asString());
                }
                ServiceBuilder builder = serviceTarget.addService(ssoName, (Service)ssoService);
                ssoService.getValue().addDependencies(serviceTarget, builder);
                newControllers.add(builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
            }
        }
        if (operation.hasDefined("default-web-module")) {
            if (welcome) {
                throw new OperationFailedException(new ModelNode().set(WebMessages.MESSAGES.noRootWebappWithWelcomeWebapp()));
            }
            service.setDefaultWebModule(operation.get("default-web-module").asString());
        }
        serviceBuilder.addListener((ServiceListener)verificationHandler);
        newControllers.add(serviceBuilder.install());
        if (welcome) {
            WelcomeContextService welcomeService = new WelcomeContextService(HOME_DIR);
            newControllers.add(context.getServiceTarget().addService(WebSubsystemServices.JBOSS_WEB.append(new String[]{name}).append(new String[]{"welcome"}), (Service)welcomeService).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, welcomeService.getPathManagerInjector()).addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{name}), VirtualHost.class, welcomeService.getHostInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, HttpManagementService.SERVICE_NAME, HttpManagement.class, welcomeService.getHttpManagementInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        }
    }

    static String[] aliases(ModelNode node) {
        if (node.hasDefined("alias")) {
            ModelNode aliases = node.require("alias");
            int size = aliases.asInt();
            String[] array = new String[size];
            for (int i = 0; i < size; ++i) {
                array[i] = aliases.get(i).asString();
            }
            return array;
        }
        return NO_ALIASES;
    }

    static String getPath(OperationContext context, ModelNode node, String hostName) throws OperationFailedException {
        return WebVirtualHostAdd.getPath(context, node, hostName, false);
    }

    static String getRelativeTo(OperationContext context, ModelNode node, String hostName) throws OperationFailedException {
        return WebVirtualHostAdd.getPath(context, node, hostName, true);
    }

    static String getPath(OperationContext context, ModelNode node, String hostName, boolean relativePart) throws OperationFailedException {
        if (node.get(new String[]{WebExtension.DIRECTORY_PATH.getKey(), WebExtension.DIRECTORY_PATH.getValue()}).isDefined()) {
            ModelNode directory = node.get(new String[]{WebExtension.DIRECTORY_PATH.getKey(), WebExtension.DIRECTORY_PATH.getValue()});
            if (relativePart) {
                return WebAccessLogDirectoryDefinition.RELATIVE_TO.resolveModelAttribute(context, directory).asString();
            }
            return WebAccessLogDirectoryDefinition.PATH.resolveModelAttribute(context, directory).asString();
        }
        if (relativePart) {
            return DEFAULT_RELATIVE_TO;
        }
        return hostName;
    }
}

