/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.ThreadBindingListener;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.web.ThreadSetupBindingListener;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.deployment.ServletContextAttribute;
import org.jboss.as.web.deployment.WebInjectionContainer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class WebDeploymentService
implements Service<Context> {
    private final StandardContext context;
    private final InjectedValue<Realm> realm = new InjectedValue();
    private final WebInjectionContainer injectionContainer;
    private final List<SetupAction> setupActions;
    final List<ServletContextAttribute> attributes;

    public WebDeploymentService(StandardContext context, WebInjectionContainer injectionContainer, List<SetupAction> setupActions, List<ServletContextAttribute> attributes) {
        this.context = context;
        this.injectionContainer = injectionContainer;
        this.setupActions = setupActions;
        this.attributes = attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext startContext) throws StartException {
        if (this.attributes != null) {
            ServletContext context = this.context.getServletContext();
            for (ServletContextAttribute attribute : this.attributes) {
                context.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        this.context.setRealm((Realm)this.realm.getValue());
        WebInjectionContainer.setWebInjectionContainer(this.injectionContainer);
        ArrayList<SetupAction> actions = new ArrayList<SetupAction>();
        actions.addAll(this.setupActions);
        this.context.setInstanceManager((InstanceManager)this.injectionContainer);
        this.context.setThreadBindingListener((ThreadBindingListener)new ThreadSetupBindingListener(actions));
        try {
            try {
                this.context.create();
            }
            catch (Exception e) {
                throw new StartException(WebMessages.MESSAGES.createContextFailed(), (Throwable)e);
            }
            try {
                this.context.start();
            }
            catch (LifecycleException e) {
                throw new StartException(WebMessages.MESSAGES.startContextFailed(), (Throwable)e);
            }
            if (this.context.getState() != 1) {
                throw new StartException(WebMessages.MESSAGES.startContextFailed());
            }
            WebLogger.WEB_LOGGER.registerWebapp(this.context.getName());
        }
        finally {
            WebInjectionContainer.clearCurrentInjectionContainer();
        }
    }

    public synchronized void stop(StopContext stopContext) {
        try {
            this.context.stop();
        }
        catch (LifecycleException e) {
            WebLogger.WEB_LOGGER.stopContextFailed(e);
        }
        try {
            this.context.destroy();
        }
        catch (Exception e) {
            WebLogger.WEB_LOGGER.destroyContextFailed(e);
        }
    }

    public synchronized Context getValue() throws IllegalStateException {
        StandardContext context = this.context;
        if (context == null) {
            throw new IllegalStateException();
        }
        return context;
    }

    public InjectedValue<Realm> getRealm() {
        return this.realm;
    }
}

