/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.WebValveDefinition;
import org.jboss.as.web.WebValveService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class WebValveAdd
extends AbstractAddStepHandler {
    static final WebValveAdd INSTANCE = new WebValveAdd();

    private WebValveAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition def : WebValveDefinition.ATTRIBUTES) {
            def.validateAndSet(operation, model);
        }
        WebValveDefinition.PARAMS.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode baseOperation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress address = PathAddress.pathAddress((ModelNode)baseOperation.get("address"));
        String name = address.getLastElement().getValue();
        String classname = null;
        ModelNode resolved = WebValveDefinition.CLASS_NAME.resolveModelAttribute(context, fullModel);
        if (resolved.isDefined()) {
            classname = resolved.asString();
        }
        String module = null;
        resolved = WebValveDefinition.MODULE.resolveModelAttribute(context, fullModel);
        if (resolved.isDefined()) {
            module = resolved.asString();
        }
        boolean enabled = WebValveDefinition.ENABLED.resolveModelAttribute(context, fullModel).asBoolean();
        WebValveService service = new WebValveService(name, classname, module);
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceBuilder serviceBuilder = serviceTarget.addService(WebSubsystemServices.JBOSS_WEB_VALVE.append(new String[]{name}), (Service)service).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getWebServer());
        resolved = WebValveDefinition.PARAMS.resolveModelAttribute(context, fullModel);
        if (resolved.isDefined()) {
            service.setParam(resolved.clone());
        }
        serviceBuilder.setInitialMode(enabled ? ServiceController.Mode.ACTIVE : ServiceController.Mode.NEVER);
        if (enabled) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        newControllers.add(serviceBuilder.install());
    }
}

