/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Hashtable;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebValve;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class WebValveService
implements Service<Valve> {
    private final String classname;
    private final String module;
    private ModelNode params;
    private final InjectedValue<WebServer> webServer = new InjectedValue();
    private Valve valve;
    private String name;

    public WebValveService(String name, String classname, String module) {
        this.classname = classname;
        this.module = module;
        this.name = name;
    }

    public synchronized void start(StartContext context) throws StartException {
        Valve valve = null;
        try {
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            ModuleIdentifier id = ModuleIdentifier.create((String)this.module);
            Module valveModule = moduleLoader.loadModule(id);
            Class classz = valveModule.getClassLoader().loadClass(this.classname);
            if (!AuthenticatorBase.class.isAssignableFrom(classz)) {
                valve = (Valve)valveModule.getClassLoader().loadClass(this.classname).newInstance();
                if (this.params != null) {
                    for (Property param : this.params.asPropertyList()) {
                        IntrospectionUtils.setProperty((Object)valve, (String)param.getName(), (String)param.getValue().asString());
                    }
                }
                ((WebServer)this.webServer.getValue()).addValve(valve);
                this.valve = valve;
            } else {
                Hashtable<String, String> properties = new Hashtable<String, String>();
                if (this.params != null) {
                    for (Property param : this.params.asPropertyList()) {
                        properties.put(param.getName(), param.getValue().asString());
                    }
                }
                ((WebServer)this.webServer.getValue()).addValve(this.name, classz, properties);
            }
            valve = WebValve.createValve(this.classname, valveModule.getClassLoader());
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.valve != null) {
            Valve valve = this.valve;
            this.valve = null;
            WebServer server = (WebServer)this.webServer.getValue();
            server.removeValve(valve);
        }
    }

    public synchronized Valve getValue() throws IllegalStateException {
        Valve valve = this.valve;
        if (valve == null) {
            throw new IllegalStateException();
        }
        return valve;
    }

    public InjectedValue<WebServer> getWebServer() {
        return this.webServer;
    }

    public ModelNode getParam() {
        return this.params;
    }

    public void setParam(ModelNode param) {
        this.params = param;
    }
}

