/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.generator.DistributionContentItem;
import org.jboss.as.patching.generator.DistributionItemImpl;
import org.jboss.as.patching.generator.DistributionModuleItem;
import org.jboss.as.patching.generator.DistributionProcessor;
import org.jboss.as.patching.generator.DistributionStructure;
import org.jboss.as.patching.generator.DistributionStructureImpl;

class Distribution {
    protected final DistributionContentItem ROOT = new DistributionItemImpl(null, null, IoUtils.NO_CONTENT, IoUtils.NO_CONTENT, false);
    private final DistributionStructure structure;
    private final Map<String, ProcessedLayer> layers = new LinkedHashMap<String, ProcessedLayer>();
    private final Map<String, ProcessedLayer> addOns = new LinkedHashMap<String, ProcessedLayer>();
    private String name;
    private String version;

    public static Distribution create(File file, String ... ignored) throws IOException {
        Distribution distribution = new Distribution();
        if (ignored != null) {
            for (String ignore : ignored) {
                distribution.structure.registerIgnoredPath(ignore);
            }
        }
        DistributionProcessor.process(distribution.ROOT, file, distribution);
        return distribution;
    }

    Distribution() {
        this.structure = new DistributionStructureImpl(this.ROOT);
    }

    DistributionContentItem getRoot() {
        return this.ROOT;
    }

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    String getVersion() {
        return this.version;
    }

    void setVersion(String version) {
        this.version = version;
    }

    Set<String> getLayers() {
        return Collections.unmodifiableSet(this.layers.keySet());
    }

    ProcessedLayer getLayer(String name) {
        return this.layers.get(name);
    }

    Set<String> getAddOns() {
        return Collections.unmodifiableSet(this.addOns.keySet());
    }

    ProcessedLayer getAddOn(String name) {
        return this.addOns.get(name);
    }

    public boolean isIgnored(DistributionContentItem item) {
        return this.structure.isIgnored(item);
    }

    public boolean isModuleLookupPath(DistributionContentItem item) {
        return this.structure.isModuleLookupPath(item);
    }

    public boolean isBundleLookupPath(DistributionContentItem item) {
        return this.structure.isBundleLookupPath(item);
    }

    protected ProcessedLayer addLayer(String name) {
        return Distribution.getOrCreate(name, this.layers);
    }

    protected ProcessedLayer addAddOn(String name) {
        return Distribution.getOrCreate(name, this.addOns);
    }

    private static ProcessedLayer getOrCreate(String layerName, Map<String, ProcessedLayer> layers) {
        ProcessedLayer layer = layers.get(layerName);
        if (layer == null) {
            layer = new ProcessedLayer(layerName);
            layers.put(layerName, layer);
        }
        return layer;
    }

    static class ProcessedLayer {
        private final String name;
        private final Set<DistributionModuleItem> bundles = new TreeSet<DistributionModuleItem>();
        private final Set<DistributionModuleItem> modules = new TreeSet<DistributionModuleItem>();

        ProcessedLayer(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        Set<DistributionModuleItem> getBundles() {
            return this.bundles;
        }

        Set<DistributionModuleItem> getModules() {
            return this.modules;
        }

        protected void addBundle(DistributionContentItem item) {
            this.bundles.add(this.createDistributionModuleItem(item));
        }

        protected void addModule(DistributionContentItem item) {
            this.modules.add(this.createDistributionModuleItem(item));
        }

        protected DistributionModuleItem createDistributionModuleItem(DistributionContentItem item) {
            String moduleName = item.getParent().getPath('.');
            String slot = item.getName();
            byte[] metadata = item.getMetadataHash();
            byte[] comparison = item.getComparisonHash();
            return new DistributionModuleItem(moduleName, slot, comparison, metadata);
        }
    }
}

