/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.generator.Distribution;
import org.jboss.as.patching.generator.DistributionContentItem;
import org.jboss.as.patching.generator.DistributionItemImpl;
import org.jboss.as.patching.generator.DistributionModuleItem;
import org.jboss.as.patching.generator.DistributionXml;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class DistributionXml_1_0
implements XMLStreamConstants,
XMLElementReader<Distribution>,
XMLElementWriter<Distribution> {
    DistributionXml_1_0() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, Distribution distribution) throws XMLStreamException {
        Set<String> addOns;
        writer.writeStartDocument();
        writer.writeStartElement(Element.DISTRIBUTION.name);
        writer.writeDefaultNamespace(DistributionXml.Namespace.DISTRIBUTION_1_0.getNamespace());
        DistributionContentItem root = distribution.getRoot();
        Collection<DistributionContentItem> children = root.getChildren();
        Set<String> layers = distribution.getLayers();
        if (!layers.isEmpty()) {
            writer.writeStartElement(Element.LAYERS.name);
            for (String layerName : layers) {
                Distribution.ProcessedLayer layer = distribution.getLayer(layerName);
                DistributionXml_1_0.writeLayer(writer, layer, Element.LAYER);
            }
            writer.writeEndElement();
        }
        if (!(addOns = distribution.getAddOns()).isEmpty()) {
            writer.writeStartElement(Element.ADD_ONS.name);
            for (String addOnName : addOns) {
                Distribution.ProcessedLayer addOn = distribution.getAddOn(addOnName);
                DistributionXml_1_0.writeLayer(writer, addOn, Element.ADD_ON);
            }
            writer.writeEndElement();
        }
        writer.writeStartElement(Element.FILES.name);
        DistributionXml_1_0.writeChildren(writer, children);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private static void writeLayer(XMLExtendedStreamWriter writer, Distribution.ProcessedLayer layer, Element element) throws XMLStreamException {
        writer.writeStartElement(element.name);
        writer.writeAttribute(Attribute.NAME.name, layer.getName());
        Set<DistributionModuleItem> bundles = layer.getBundles();
        Set<DistributionModuleItem> modules = layer.getModules();
        if (!bundles.isEmpty()) {
            writer.writeStartElement(Element.BUNDLES.name);
            for (DistributionModuleItem item : bundles) {
                DistributionXml_1_0.writeModuleItem(writer, item, Element.BUNDLE);
            }
            writer.writeEndElement();
        }
        if (!modules.isEmpty()) {
            writer.writeStartElement(Element.MODULES.name);
            for (DistributionModuleItem item : modules) {
                DistributionXml_1_0.writeModuleItem(writer, item, Element.MODULE);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static void writeModuleItem(XMLExtendedStreamWriter writer, DistributionModuleItem item, Element element) throws XMLStreamException {
        writer.writeEmptyElement(element.name);
        writer.writeAttribute(Attribute.NAME.name, item.getName());
        writer.writeAttribute(Attribute.SLOT.name, item.getSlot());
        writer.writeAttribute(Attribute.COMPARISON_HASH.name, HashUtils.bytesToHexString((byte[])item.getComparisonHash()));
        writer.writeAttribute(Attribute.METADATA_HASH.name, HashUtils.bytesToHexString((byte[])item.getMetadataHash()));
    }

    private static void writeChildren(XMLExtendedStreamWriter writer, Collection<DistributionContentItem> items) throws XMLStreamException {
        if (items == null || items.size() == 0) {
            return;
        }
        for (DistributionContentItem item : items) {
            writer.writeStartElement(Element.NODE.name);
            writer.writeAttribute(Attribute.NAME.name, item.getName());
            if (item.isLeaf()) {
                writer.writeAttribute(Attribute.COMPARISON_HASH.name, HashUtils.bytesToHexString((byte[])item.getComparisonHash()));
                writer.writeAttribute(Attribute.METADATA_HASH.name, HashUtils.bytesToHexString((byte[])item.getMetadataHash()));
            }
            writer.writeAttribute(Attribute.DIRECTORY.name, String.valueOf(!item.isLeaf()));
            Collection<DistributionContentItem> children = item.getChildren();
            DistributionXml_1_0.writeChildren(writer, children);
            writer.writeEndElement();
        }
    }

    public void readElement(XMLExtendedStreamReader reader, Distribution distribution) throws XMLStreamException {
        DistributionContentItem root = distribution.getRoot();
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LAYERS: 
                case ADD_ONS: {
                    DistributionXml_1_0.readLayers(reader, distribution);
                    continue block4;
                }
                case FILES: {
                    DistributionXml_1_0.readNodes(reader, root);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected static void readLayers(XMLExtendedStreamReader reader, Distribution distribution) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LAYER: {
                    DistributionXml_1_0.readLayer(reader, distribution, false);
                    continue block4;
                }
                case ADD_ON: {
                    DistributionXml_1_0.readLayer(reader, distribution, true);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected static void readLayer(XMLExtendedStreamReader reader, Distribution distribution, boolean addOn) throws XMLStreamException {
        Distribution.ProcessedLayer layer;
        String name = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        Distribution.ProcessedLayer processedLayer = layer = addOn ? distribution.addAddOn(name) : distribution.addLayer(name);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case MODULES: {
                    DistributionXml_1_0.readModuleItems(reader, layer);
                    continue block8;
                }
                case BUNDLES: {
                    DistributionXml_1_0.readModuleItems(reader, layer);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected static void readModuleItems(XMLExtendedStreamReader reader, Distribution.ProcessedLayer layer) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BUNDLE: {
                    DistributionModuleItem item = DistributionXml_1_0.readModuleItem(reader);
                    layer.getBundles().add(item);
                    continue block4;
                }
                case MODULE: {
                    DistributionModuleItem item = DistributionXml_1_0.readModuleItem(reader);
                    layer.getModules().add(item);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected static DistributionModuleItem readModuleItem(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        String slot = null;
        String metadata = null;
        String comparison = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block6;
                }
                case SLOT: {
                    slot = value;
                    continue block6;
                }
                case COMPARISON_HASH: {
                    comparison = value;
                    continue block6;
                }
                case METADATA_HASH: {
                    metadata = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null || slot == null || comparison == null || metadata == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name", "slot", "comparison", "metadata"});
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return new DistributionModuleItem(name, slot, HashUtils.hexStringToByteArray((String)comparison), HashUtils.hexStringToByteArray((String)metadata));
    }

    protected static void readNodes(XMLExtendedStreamReader reader, DistributionContentItem parent) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NODE: {
                    DistributionXml_1_0.readNode(reader, parent);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected static void readNode(XMLExtendedStreamReader reader, DistributionContentItem parent) throws XMLStreamException {
        String name = null;
        String directory = null;
        String comparison = "";
        String metadata = "";
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                case DIRECTORY: {
                    directory = value;
                    continue block9;
                }
                case COMPARISON_HASH: {
                    comparison = value;
                    continue block9;
                }
                case METADATA_HASH: {
                    metadata = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        DistributionItemImpl item = new DistributionItemImpl(parent, name, HashUtils.hexStringToByteArray((String)comparison), HashUtils.hexStringToByteArray((String)metadata), Boolean.valueOf(directory) == false);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NODE: {
                    DistributionXml_1_0.readNode(reader, item);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        parent.getChildren().add(item);
    }

    static enum Attribute {
        DIRECTORY("directory"),
        COMPARISON_HASH("comparison-hash"),
        METADATA_HASH("metadata-hash"),
        NAME("name"),
        SLOT("slot"),
        UNKNOWN(null);

        private final String name;
        static Map<String, Attribute> attributes;

        private Attribute(String name) {
            this.name = name;
        }

        static Attribute forName(String name) {
            Attribute attribute = attributes.get(name);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            attributes = new HashMap<String, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                if (attribute == UNKNOWN) continue;
                attributes.put(attribute.name, attribute);
            }
        }
    }

    static enum Element {
        ADD_ON("add-on"),
        ADD_ONS("add-ons"),
        BUNDLE("bundle"),
        BUNDLES("bundles"),
        DISTRIBUTION("distribution"),
        FILES("files"),
        LAYER("layer"),
        LAYERS("layers"),
        MODULE("module"),
        MODULES("modules"),
        NODE("node"),
        UNKNOWN(null);

        final String name;
        static Map<String, Element> elements;

        private Element(String name) {
            this.name = name;
        }

        static Element forName(String name) {
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            elements = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                if (element == UNKNOWN) continue;
                elements.put(element.name, element);
            }
        }
    }
}

