/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.generator.JarDiffUtils;

class ModuleDiffUtils
implements XMLStreamConstants {
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    protected static volatile boolean deepInspection = false;

    ModuleDiffUtils() {
    }

    public static byte[] processModule(File root, String moduleName, byte[] metadataHash) throws IOException, NoSuchAlgorithmException {
        if (!deepInspection) {
            return metadataHash;
        }
        File moduleXml = new File(root, "module.xml");
        if (!moduleXml.isFile()) {
            throw new IOException("not a module" + root.getAbsolutePath());
        }
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        MessageDigest moduleDigest = MessageDigest.getInstance("SHA1");
        try (FileInputStream stream = new FileInputStream(moduleXml);){
            XMLInputFactory inputFactory = INPUT_FACTORY;
            ModuleDiffUtils.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
            ModuleDiffUtils.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
            XMLStreamReader reader = inputFactory.createXMLStreamReader(stream);
            ModuleDiffUtils.processRoot(reader, moduleDigest, resources);
        }
        for (String path : resources) {
            File resource = new File(root, path);
            if (!resource.exists()) {
                throw new FileNotFoundException(resource.getAbsolutePath());
            }
            if (path.endsWith(".jar")) {
                try {
                    JarDiffUtils.internalJarComparison(resource, moduleDigest, false);
                    continue;
                }
                catch (Exception e) {
                    throw new IOException("failed to process " + resource.getAbsolutePath(), e);
                }
            }
            moduleDigest.update(HashUtils.hashFile((File)resource));
        }
        File lib = new File(root, "lib");
        if (lib.exists()) {
            moduleDigest.update(HashUtils.hashFile((File)lib));
        }
        return moduleDigest.digest();
    }

    protected static void processRoot(XMLStreamReader reader, MessageDigest digest, Set<String> resources) throws XMLStreamException {
        reader.require(7, null, null);
        reader.nextTag();
        reader.require(1, null, null);
        String namespace = reader.getNamespaceURI();
        digest.update(namespace.getBytes());
        ModuleDiffUtils.processAttributes(reader, digest);
        ModuleDiffUtils.processXml(reader, digest, resources);
        while (reader.next() != 8) {
        }
    }

    protected static void processXml(XMLStreamReader reader, MessageDigest digest, Set<String> resources) throws XMLStreamException {
        ModuleDiffUtils.processAttributes(reader, digest);
        while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            if (localName.equals("resources")) {
                ModuleDiffUtils.processResources(reader, resources);
                continue;
            }
            digest.update(localName.getBytes());
            ModuleDiffUtils.processXml(reader, digest, resources);
        }
    }

    protected static void processAttributes(XMLStreamReader reader, MessageDigest digest) {
        int attributes = reader.getAttributeCount();
        for (int i = 0; i < attributes; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            digest.update(name.getBytes());
            digest.update(value.getBytes());
        }
    }

    protected static void processResources(XMLStreamReader reader, Set<String> resources) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            if ("resource-root".equals(localName)) {
                ModuleDiffUtils.processResource(reader, resources);
                continue;
            }
            throw new XMLStreamException("unrecognized element " + localName);
        }
    }

    protected static void processResource(XMLStreamReader reader, Set<String> resources) throws XMLStreamException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount != 1) {
            throw new XMLStreamException();
        }
        String path = reader.getAttributeValue(0);
        resources.add(path.trim());
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw new XMLStreamException("unexpected element");
        }
    }

    private static void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }
}

