/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.UUID;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.logging.PatchLogger;

class TemplateGenerator {
    private static final String TAB = "   ";
    private static final String LF = "\r\n";

    TemplateGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String generate(String ... args) throws IOException {
        boolean stdout = false;
        Boolean oneOff = null;
        String patchID = UUID.randomUUID().toString();
        String appliesToVersion = null;
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if ("--help".equals(arg) || "-h".equals(arg) || "-H".equals(arg)) {
                    TemplateGenerator.usage();
                    return null;
                }
                if (arg.equals("--one-off")) {
                    if (oneOff == null) {
                        oneOff = Boolean.TRUE;
                        patchID = args[++i];
                        continue;
                    }
                    TemplateGenerator.usage();
                    return null;
                }
                if (arg.equals("--cumulative")) {
                    if (oneOff == null) {
                        oneOff = Boolean.FALSE;
                        patchID = args[++i];
                        continue;
                    }
                    TemplateGenerator.usage();
                    return null;
                }
                if (arg.equals("--applies-to-version")) {
                    appliesToVersion = args[++i];
                    continue;
                }
                if (arg.equals("--std.out")) {
                    stdout = true;
                    continue;
                }
                if (arg.equals("--create-template")) continue;
                System.err.println(PatchLogger.ROOT_LOGGER.argumentExpected(arg));
                TemplateGenerator.usage();
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println(PatchLogger.ROOT_LOGGER.argumentExpected(arg));
                TemplateGenerator.usage();
                return null;
            }
        }
        if (oneOff == null) {
            TemplateGenerator.usage();
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version='1.0' encoding='UTF-8'?>").append(LF);
        builder.append("<patch-config xmlns=\"urn:jboss:patch-config:1.0\">").append(LF);
        builder.append(TAB).append("<name>").append(patchID).append("</name>").append(LF);
        builder.append(TAB).append("<description>No description available</description>").append(LF);
        builder.append(TAB);
        if (oneOff.booleanValue()) {
            builder.append("<one-off ");
        } else {
            builder.append("<cumulative ");
        }
        if (appliesToVersion != null) {
            builder.append("applies-to-version=\"").append(appliesToVersion).append("\"");
        }
        builder.append(" />").append(LF);
        builder.append(TAB).append("<element patch-id=\"").append("layer-base-").append(patchID).append("\">").append(LF);
        builder.append(TAB).append(TAB);
        if (oneOff.booleanValue()) {
            builder.append("<one-off ");
        } else {
            builder.append("<cumulative ");
        }
        builder.append("name=\"base\" />").append(LF);
        builder.append(TAB).append(TAB).append("<description>No description available</description>").append(LF);
        if (oneOff.booleanValue()) {
            builder.append(TAB).append(TAB).append("<specified-content>").append(LF);
            builder.append(TAB).append(TAB).append(TAB).append("<modules>").append(LF);
            builder.append(TAB).append(TAB).append(TAB).append(TAB).append("<updated name=\"org.jboss.as.server\" />").append(LF);
            builder.append(TAB).append(TAB).append(TAB).append("</modules>").append(LF);
            builder.append(TAB).append(TAB).append("</specified-content>").append(LF);
        }
        builder.append(TAB).append("</element>").append(LF);
        if (oneOff.booleanValue()) {
            builder.append(TAB).append("<specified-content>").append(LF);
            builder.append(TAB).append(TAB).append("<misc-files>").append(LF);
            builder.append(TAB).append(TAB).append(TAB).append("<updated path=\"version.txt\" />").append(LF);
            builder.append(TAB).append(TAB).append("</misc-files>").append(LF);
            builder.append(TAB).append("</specified-content>").append(LF);
        } else {
            builder.append(TAB).append("<generate-by-diff />").append(LF);
        }
        builder.append("</patch-config>").append(LF);
        String output = builder.toString();
        if (stdout) {
            System.out.println(output);
        } else {
            File file = new File("patch-config-" + patchID + ".xml");
            FileWriter writer = new FileWriter(file);
            try {
                writer.write(output);
                ((Writer)writer).close();
            }
            finally {
                IoUtils.safeClose((Closeable)writer);
            }
        }
        return output;
    }

    static void usage() {
        StringBuilder builder = new StringBuilder();
        builder.append("USAGE:").append(LF);
        builder.append("patch-gen.sh --create-template --one-of     [patch-id]").append(LF);
        builder.append("patch-gen.sh --create-template --cumulative [patch-id]").append(LF);
        builder.append(LF);
        builder.append("this will create a patch-config-[patch-id].xml").append(LF);
        builder.append("if this is not desired just append --std.out").append(LF);
        System.err.println(builder.toString());
    }
}

