/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.ZipUtils;
import org.jboss.as.patching.generator.PatchGenLogger;
import org.jboss.as.patching.generator.PatchGenerator;
import org.jboss.as.patching.metadata.BundledPatch;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBundleXml;
import org.jboss.as.patching.metadata.PatchXml;

class PatchBundleGenerator {
    private static final String LF = "\r\n";
    private File tmp;

    PatchBundleGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assemble(String ... args) throws Exception {
        String[] s;
        String patchArg = null;
        String existingArg = null;
        String outputArg = null;
        for (String arg : args) {
            try {
                if ("--help".equals(arg) || "-h".equals(arg) || "-H".equals(arg)) {
                    PatchBundleGenerator.usage();
                    return;
                }
                if (arg.startsWith("--patch=")) {
                    patchArg = arg.substring("--patch=".length());
                    continue;
                }
                if (arg.startsWith("--existing=")) {
                    existingArg = arg.substring("--existing=".length());
                    continue;
                }
                if (arg.startsWith("--output=")) {
                    outputArg = arg.substring("--output=".length());
                    continue;
                }
                if (arg.equals("--assemble-patch-bundle")) continue;
                System.err.println(PatchGenLogger.argumentExpected(arg));
                PatchBundleGenerator.usage();
                return;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println(PatchGenLogger.argumentExpected(arg));
                PatchBundleGenerator.usage();
                return;
            }
        }
        HashSet<String> missing = new HashSet<String>();
        if (patchArg == null) {
            missing.add("--patch");
        }
        if (outputArg == null) {
            missing.add("--output");
        }
        if (!missing.isEmpty()) {
            System.err.println(PatchGenLogger.missingRequiredArgs(missing));
            return;
        }
        PatchBundleGenerator gen = new PatchBundleGenerator();
        gen.createTempStructure(UUID.randomUUID().toString());
        ArrayList<File> patches = new ArrayList<File>();
        for (String p : s = patchArg.split(File.pathSeparator)) {
            File f = new File(p);
            if (!f.isFile()) {
                throw new FileNotFoundException(f.getAbsolutePath());
            }
            patches.add(f);
        }
        File e = existingArg == null ? null : new File(existingArg);
        File t = new File(outputArg);
        try {
            gen.assemble(patches, e, t);
        }
        finally {
            IoUtils.recursiveDelete((File)gen.tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assemble(List<File> patches, File existing, File target) throws IOException, XMLStreamException, PatchingException {
        BundledPatch metadata;
        File multiPatchContent = new File(this.tmp, "patch-bundle-content");
        multiPatchContent.mkdir();
        File multiPatchXml = new File(multiPatchContent, "patches.xml");
        if (existing != null && existing.exists()) {
            ZipUtils.unzip((File)existing, (File)multiPatchContent);
            FileInputStream is = new FileInputStream(multiPatchXml);
            try {
                metadata = PatchBundleXml.parse((InputStream)is);
            }
            finally {
                IoUtils.safeClose((Closeable)is);
            }
        } else {
            metadata = new BundledPatch(){

                public List<BundledPatch.BundledPatchEntry> getPatches() {
                    return Collections.emptyList();
                }
            };
        }
        int i = 0;
        final ArrayList<BundledPatch.BundledPatchEntry> entries = new ArrayList<BundledPatch.BundledPatchEntry>(metadata.getPatches());
        for (File patch : patches) {
            File patchContent = new File(this.tmp, "patch-content-" + i);
            ZipUtils.unzip((File)patch, (File)patchContent);
            File patchXml = new File(patchContent, "patch.xml");
            Patch patchMetadata = PatchXml.parse((File)patchXml).resolvePatch(null, null);
            String patchID = patchMetadata.getPatchId();
            String patchPath = patchID + ".zip";
            entries.add(new BundledPatch.BundledPatchEntry(patchID, patchPath));
            File patchTarget = new File(multiPatchContent, patchPath);
            IoUtils.copyFile((File)patch, (File)patchTarget);
            ++i;
        }
        FileOutputStream os = new FileOutputStream(multiPatchXml);
        try {
            PatchBundleXml.marshal((OutputStream)os, (BundledPatch)new BundledPatch(){

                public List<BundledPatch.BundledPatchEntry> getPatches() {
                    return entries;
                }
            });
        }
        finally {
            IoUtils.safeClose((Closeable)os);
        }
        ZipUtils.zip((File)multiPatchContent, (File)target);
    }

    private void createTempStructure(String patchId) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        int count = 0;
        while (this.tmp == null || this.tmp.exists()) {
            this.tmp = new File(tmpDir, "jboss-as-patch-" + patchId + "-" + ++count);
        }
        if (!this.tmp.mkdirs()) {
            throw PatchGenerator.processingError("Cannot create tmp dir for patch create at %s", this.tmp.getAbsolutePath());
        }
        this.tmp.deleteOnExit();
    }

    static void usage() {
        StringBuilder builder = new StringBuilder();
        builder.append("USAGE:").append(LF);
        builder.append("patch-gen.sh --assemble-patch-bundle --patch=/path/to/the/patch --existing=/path/to/existing/patch/bundle --output=/path/to/the/output").append(LF);
        System.err.println(builder.toString());
    }
}

