/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.UUID;
import org.jboss.as.patching.generator.PatchGenLogger;

class TemplateGenerator {
    private static final String APPLIES_TO_VERSION = "--applies-to-version";
    private static final String CREATE_TEMPLATE = "--create-template";
    private static final String CUMULATIVE = "--cumulative";
    private static final String DEFAULT_OPTIONAL_PATHS = "--default-optional-paths";
    private static final String H = "-h";
    private static final String HELP = "--help";
    private static final String ONE_OFF = "--one-off";
    private static final String STD_OUT = "--std.out";
    private static final String TAB = "    ";

    TemplateGenerator() {
    }

    static void generate(String ... args) throws IOException {
        boolean stdout = false;
        Boolean oneOff = null;
        String patchID = UUID.randomUUID().toString();
        String appliesToVersion = null;
        boolean defaultOptionalPaths = false;
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if (HELP.equals(arg) || H.equalsIgnoreCase(arg)) {
                    TemplateGenerator.usage();
                    return;
                }
                if (arg.equals(ONE_OFF)) {
                    if (oneOff == null) {
                        oneOff = Boolean.TRUE;
                        patchID = args[++i];
                        continue;
                    }
                    TemplateGenerator.usage();
                    return;
                }
                if (arg.equals(CUMULATIVE)) {
                    if (oneOff == null) {
                        oneOff = Boolean.FALSE;
                        patchID = args[++i];
                        continue;
                    }
                    TemplateGenerator.usage();
                    return;
                }
                if (arg.equals(APPLIES_TO_VERSION)) {
                    appliesToVersion = args[++i];
                    continue;
                }
                if (arg.equals(STD_OUT)) {
                    stdout = true;
                    continue;
                }
                if (arg.equals(CREATE_TEMPLATE)) continue;
                if (arg.equals(DEFAULT_OPTIONAL_PATHS)) {
                    defaultOptionalPaths = true;
                    continue;
                }
                System.err.println(PatchGenLogger.argumentExpected(arg));
                TemplateGenerator.usage();
                return;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println(PatchGenLogger.argumentExpected(arg));
                TemplateGenerator.usage();
                return;
            }
        }
        if (oneOff == null) {
            TemplateGenerator.usage();
            return;
        }
        OutputStreamWriter target = stdout ? new OutputStreamWriter(System.out) : new FileWriter(new File("patch-config-" + patchID + ".xml"));
        try (BufferedWriter bw = new BufferedWriter(target);){
            bw.write("<?xml version='1.0' encoding='UTF-8'?>");
            bw.newLine();
            TemplateGenerator.elementStart(bw, 0, "patch-config", "xmlns", "urn:jboss:patch-config:1.0");
            TemplateGenerator.elementWithContent(bw, 1, "name", patchID);
            TemplateGenerator.elementWithContent(bw, 1, "description", "No description available");
            TemplateGenerator.elementWithAttrs(bw, 1, oneOff != false ? "one-off" : "cumulative", "applies-to-version", appliesToVersion);
            TemplateGenerator.elementStart(bw, 1, "element", "patch-id", "layer-base-" + patchID);
            TemplateGenerator.elementWithAttrs(bw, 2, oneOff != false ? "one-off" : "cumulative", "name", "base");
            TemplateGenerator.elementWithContent(bw, 2, "description", "No description available");
            if (oneOff.booleanValue()) {
                TemplateGenerator.elementStart(bw, 2, "specified-content");
                TemplateGenerator.elementStart(bw, 3, "modules");
                TemplateGenerator.elementWithAttrs(bw, 4, "updated", "name", "org.jboss.as.server");
                TemplateGenerator.elementEnd(bw, 3, "modules");
                TemplateGenerator.elementEnd(bw, 2, "specified-content");
            }
            TemplateGenerator.elementEnd(bw, 1, "element");
            if (oneOff.booleanValue()) {
                TemplateGenerator.elementStart(bw, 1, "specified-content");
                TemplateGenerator.elementStart(bw, 2, "misc-files");
                TemplateGenerator.elementWithAttrs(bw, 3, "updated", "path", "version.txt");
                TemplateGenerator.elementEnd(bw, 2, "misc-files");
                TemplateGenerator.elementEnd(bw, 1, "specified-content");
            } else {
                TemplateGenerator.element(bw, 1, "generate-by-diff");
            }
            if (defaultOptionalPaths) {
                TemplateGenerator.elementStart(bw, 1, "optional-paths");
                TemplateGenerator.elementWithAttrs(bw, 2, "path", "value", "docs");
                TemplateGenerator.elementWithAttrs(bw, 2, "path", "value", "appclient");
                TemplateGenerator.elementWithAttrs(bw, 2, "path", "value", "bin/appclient.*", "requires", "appclient");
                TemplateGenerator.elementEnd(bw, 1, "optional-paths");
            }
            TemplateGenerator.elementEnd(bw, 0, "patch-config");
        }
    }

    private static void elementStart(BufferedWriter writer, int offset, String name) throws IOException {
        TemplateGenerator.elementStart(writer, offset, name, null);
    }

    private static void elementStart(BufferedWriter writer, int offset, String name, String ... attrs) throws IOException {
        TemplateGenerator.writeStart(writer, offset, name, false, attrs);
        writer.newLine();
    }

    private static void element(BufferedWriter writer, int offset, String name) throws IOException {
        TemplateGenerator.elementWithContent(writer, offset, name, null);
    }

    private static void elementWithContent(BufferedWriter writer, int offset, String name, String content) throws IOException {
        TemplateGenerator.element(writer, offset, name, content, null);
    }

    private static void elementWithAttrs(BufferedWriter writer, int offset, String name, String ... attrs) throws IOException {
        TemplateGenerator.element(writer, offset, name, null, attrs);
    }

    private static void element(BufferedWriter writer, int offset, String name, String content, String ... attrs) throws IOException {
        TemplateGenerator.writeStart(writer, offset, name, content == null, attrs);
        if (content != null) {
            writer.write(content);
            TemplateGenerator.elementEnd(writer, 0, name);
        }
    }

    private static void elementEnd(BufferedWriter writer, int offset, String name) throws IOException {
        for (int i = 0; i < offset; ++i) {
            writer.write(TAB);
        }
        writer.write("</");
        writer.write(name);
        writer.write(62);
        writer.newLine();
    }

    private static void writeStart(BufferedWriter writer, int offset, String name, boolean empty, String ... attrs) throws IOException {
        int i;
        for (i = 0; i < offset; ++i) {
            writer.write(TAB);
        }
        writer.write(60);
        writer.write(name);
        if (attrs != null && attrs.length > 0) {
            i = 0;
            while (i < attrs.length) {
                String attrValue;
                String attrName = attrs[i++];
                if ((attrValue = attrs[i++]) == null) continue;
                writer.write(32);
                writer.write(attrName);
                writer.write("=\"");
                writer.write(attrValue);
                writer.write(34);
            }
        }
        if (empty) {
            writer.write("/>");
            writer.newLine();
        } else {
            writer.write(62);
        }
    }

    static void usage() {
        System.err.println("USAGE:");
        System.err.println("patch-gen.sh --create-template --one-off    [patch-id] [--default-optional-paths]");
        System.err.println("patch-gen.sh --create-template --cumulative [patch-id] [--applies-to-version] [--default-optional-paths]");
        System.err.println();
        System.err.println("this will create a patch-config-[patch-id].xml");
        System.err.println("if this is not desired just append --std.out");
    }
}

