/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.standalone.ServerUpdateActionResult;
import org.jboss.as.plugin.deployment.IgnoredPackageTypes;
import org.jboss.as.plugin.deployment.common.AbstractServerConnection;
import org.jboss.dmr.ModelNode;

abstract class AbstractDeployment
extends AbstractServerConnection {
    private static final String CHILD_TYPE = "child-type";
    private static final String FAILED = "failed";
    private static final String READ_CHILDREN_NAMES_OPERATION = "read-children-names";
    private static final String NO_NAME_MSG = "No name defined, using default deployment name.";
    private static final String NAME_DEFINED_MSG_FMT = "Using '%s' for the deployment name.";
    private MavenProject project;
    private String name;
    private String packaging;
    private File targetDir;
    private String filename;
    private boolean skip;

    AbstractDeployment() {
    }

    public String name() {
        return this.name;
    }

    public final File targetDirectory() {
        return this.targetDir;
    }

    public File file() {
        return new File(this.targetDir, this.filename);
    }

    public String deploymentName() {
        return this.name() == null ? this.file().getName() : this.name();
    }

    public abstract DeploymentPlan createPlan(DeploymentPlanBuilder var1) throws IOException, MojoFailureException;

    @Override
    public abstract String goal();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping deployment of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        try {
            if (this.checkPackaging() && IgnoredPackageTypes.isIgnored(this.packaging)) {
                this.getLog().debug((CharSequence)String.format("Ignoring packaging type %s.", this.packaging));
            } else {
                InetAddress host = this.hostAddress();
                this.getLog().info((CharSequence)String.format("Executing goal %s on server %s (%s) port %s.", this.goal(), host.getHostName(), host.getHostAddress(), this.port()));
                ServerDeploymentManager manager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.client());
                InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
                DeploymentPlan plan = this.createPlan((DeploymentPlanBuilder)builder);
                if (plan == null) {
                    this.getLog().debug((CharSequence)String.format("Ignoring goal %s as the plan was null.", this.goal()));
                } else if (plan.getDeploymentActions().size() > 0) {
                    ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)manager.execute(plan).get();
                    for (DeploymentAction action : plan.getDeploymentActions()) {
                        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(action.getId());
                        ServerUpdateActionResult.Result result = actionResult.getResult();
                        switch (result) {
                            case FAILED: {
                                throw new MojoExecutionException("Deployment failed.", actionResult.getDeploymentException());
                            }
                            case NOT_EXECUTED: {
                                throw new MojoExecutionException("Deployment not executed.", actionResult.getDeploymentException());
                            }
                            case ROLLED_BACK: {
                                throw new MojoExecutionException("Deployment failed and was rolled back.", actionResult.getDeploymentException());
                            }
                            case CONFIGURATION_MODIFIED_REQUIRES_RESTART: {
                                this.getLog().warn((CharSequence)"Action was executed, but the server requires a restart.");
                                break;
                            }
                        }
                        this.getLog().debug((CharSequence)String.format("Deployment Plan Id : %s", planResult.getDeploymentPlanId()));
                    }
                } else {
                    this.getLog().warn((CharSequence)String.format("Goal %s failed on file %s. No deployment actions exist. Plan: %s", this.goal(), this.file().getName(), plan));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s on %s. Reason: %s", this.goal(), this.file().getName(), e.getMessage()), e);
        }
    }

    protected final boolean deploymentExists() throws IOException {
        ModelNode op = new ModelNode();
        op.get("operation").set(READ_CHILDREN_NAMES_OPERATION);
        op.get(CHILD_TYPE).set("deployment");
        ModelNode result = this.client().execute(op);
        String deploymentName = this.deploymentName();
        if (result.hasDefined("outcome")) {
            if (result.get("outcome").asString().equals("success")) {
                List deployments = result.hasDefined("result") ? result.get("result").asList() : Collections.emptyList();
                for (ModelNode n : deployments) {
                    if (!n.asString().equals(deploymentName)) continue;
                    return true;
                }
            } else if (result.get("outcome").asString().equals(FAILED)) {
                this.getLog().warn((CharSequence)String.format("A failure occurred when checking existing deployments. Error: %s", result.hasDefined("failure-description") ? result.get("failure-description").asString() : "Unknown"));
            }
        } else {
            this.getLog().warn((CharSequence)String.format("An unexpected response was found checking the deployment. Result: %s", result));
        }
        return false;
    }

    protected String nameNotDefinedMessage() {
        return NO_NAME_MSG;
    }

    protected String nameDefinedMessage() {
        return String.format(NAME_DEFINED_MSG_FMT, this.name());
    }

    protected boolean checkPackaging() {
        return true;
    }
}

