/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.plugin.deployment.Deploy;

public final class DeployArtifact
extends Deploy {
    private String groupId;
    private String artifactId;
    private MavenProject project;
    private File file;
    private String name;

    @Override
    public DeploymentPlan createPlan(DeploymentPlanBuilder builder) throws IOException, MojoFailureException {
        if (this.artifactId == null) {
            throw new MojoFailureException("deploy-artifact must specify the artifactId");
        }
        if (this.groupId == null) {
            throw new MojoFailureException("deploy-artifact must specify the groupId");
        }
        Set dependencies = this.project.getArtifacts();
        Artifact artifact = null;
        for (Artifact a : dependencies) {
            if (!a.getArtifactId().equals(this.artifactId) || !a.getGroupId().equals(this.groupId)) continue;
            artifact = a;
            break;
        }
        if (artifact == null) {
            throw new MojoFailureException("Could not resolve artifact to deploy " + this.groupId + ":" + this.artifactId);
        }
        this.file = artifact.getFile();
        return super.createPlan(builder);
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String goal() {
        return "deploy";
    }

    @Override
    protected boolean checkPackaging() {
        return false;
    }
}

