/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment.resource;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.plugin.deployment.common.AbstractServerConnection;
import org.jboss.as.plugin.deployment.resource.Resource;
import org.jboss.dmr.ModelNode;

public class AddResource
extends AbstractServerConnection {
    public static final String GOAL = "add-resource";
    private String address;
    private Map<String, String> properties;
    private Resource resource;
    private Resource[] resources;
    private boolean force;

    @Override
    public String goal() {
        return GOAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            InetAddress host = this.hostAddress();
            this.getLog().info((CharSequence)String.format("Executing goal %s on server %s (%s) port %s.", this.goal(), host.getHostName(), host.getHostAddress(), this.port()));
            ModelControllerClient client = this.client();
            try {
                if (this.resources == null) {
                    Resource resource = this.resource == null ? new Resource(this.address, this.properties, false) : this.resource;
                    this.processResources(client, resource);
                } else if (this.resources.length > 0) {
                    this.processResources(client, this.resources);
                } else {
                    this.getLog().warn((CharSequence)"No resources were provided.");
                }
            }
            finally {
                this.safeCloseClient();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s. Reason: %s", this.goal(), e.getMessage()), e);
        }
    }

    private void processResources(ModelControllerClient client, Resource ... resources) throws IOException {
        for (Resource resource : resources) {
            ModelNode op = new ModelNode();
            op.get("operation").set("composite");
            op.get("address").setEmptyList();
            op.get("rollback-on-runtime-failure").set(true);
            if (!this.addCompositeResource(client, resource, op, true)) continue;
            ModelNode r = client.execute(OperationBuilder.create((ModelNode)op).build());
            this.reportFailure(r);
        }
    }

    private boolean addCompositeResource(ModelControllerClient client, Resource resource, ModelNode compositeOp, boolean checkExistence) throws IOException {
        String address = this.address == null ? resource.getAddress() : (this.address.equals(resource.getAddress()) ? resource.getAddress() : (resource.getAddress() == null ? this.address : String.format("%s,%s", this.address, resource.getAddress())));
        if (address == null) {
            throw new RuntimeException("You must specify the address to deploy the resource to.");
        }
        if (checkExistence) {
            boolean exists = this.resourceExists(address, client);
            if (resource.isAddIfAbsent() && exists) {
                return false;
            }
            if (exists && this.force) {
                ModelNode r = client.execute(OperationBuilder.create((ModelNode)this.buildRemoveOperation(address)).build());
                this.reportFailure(r);
            } else if (exists && !this.force) {
                throw new RuntimeException("Resource " + address + " already exists.");
            }
        }
        compositeOp.get("steps").add(this.buildAddOperation(address, resource.getProperties()));
        if (resource.getResources() != null) {
            for (Resource r : resource.getResources()) {
                this.addCompositeResource(client, r, compositeOp, false);
            }
        }
        if (resource.isEnableResource()) {
            compositeOp.get("steps").add(this.buildEnableOperation(address));
        }
        return true;
    }

    private ModelNode buildRemoveOperation(String address) {
        ModelNode op = new ModelNode();
        op.get("operation").set("remove");
        op.get("recursive").set(true);
        this.setupAddress(address, op);
        return op;
    }

    private ModelNode buildEnableOperation(String address) {
        ModelNode op = new ModelNode();
        op.get("operation").set("enable");
        this.setupAddress(address, op);
        return op;
    }

    private ModelNode buildAddOperation(String address, Map<String, String> properties) {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        this.setupAddress(address, op);
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            String value;
            String[] props = prop.getKey().split(",");
            if (props.length == 0) {
                throw new RuntimeException("Invalid property " + prop);
            }
            ModelNode node = op;
            for (int i = 0; i < props.length - 1; ++i) {
                node = node.get(props[i]);
            }
            String string = value = prop.getValue() == null ? "" : prop.getValue();
            if (value.startsWith("!!")) {
                this.handleDmrString(node, props[props.length - 1], value);
                continue;
            }
            node.get(props[props.length - 1]).set(value);
        }
        return op;
    }

    private boolean resourceExists(String address, ModelControllerClient client) throws IOException {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-resource");
        request.get("recursive").set(false);
        AddressPair childAddress = this.setupParentAddress(address, request);
        ModelNode r = client.execute(new OperationBuilder(request).build());
        this.reportFailure(r);
        boolean found = false;
        if (r.get("result").get(childAddress.type).isDefined()) {
            for (ModelNode dataSource : r.get("result").get(childAddress.type).asList()) {
                if (!dataSource.asProperty().getName().equals(childAddress.name)) continue;
                found = true;
            }
        }
        return found;
    }

    private void handleDmrString(ModelNode node, String name, String value) {
        String realValue = value.substring(2);
        node.get(name).set(ModelNode.fromString((String)realValue));
    }

    private void setupAddress(String inputAddress, ModelNode request) {
        String[] parts;
        for (String part : parts = inputAddress.split(",")) {
            String[] address = part.split("=");
            if (address.length != 2) {
                throw new RuntimeException(part + " is not a valid address segment");
            }
            request.get("address").add(address[0], address[1]);
        }
    }

    private void reportFailure(ModelNode node) {
        if (!node.get("outcome").asString().equals("success")) {
            String msg = node.hasDefined("failure-description") ? (node.hasDefined("operation") ? String.format("Operation '%s' at address '%s' failed: %s", node.get("operation"), node.get("address"), node.get("failure-description")) : String.format("Operation failed: %s", node.get("failure-description"))) : String.format("Operation failed: %s", node);
            throw new RuntimeException(msg);
        }
    }

    private AddressPair setupParentAddress(String address, ModelNode request) {
        String[] parts = address.split(",");
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            String[] addressParts = part.split("=");
            if (addressParts.length != 2) {
                throw new RuntimeException(part + " is not a valid address segment");
            }
            request.get("address").add(addressParts[0], addressParts[1]);
        }
        String part = parts[parts.length - 1];
        String[] addressParts = part.split("=");
        if (addressParts.length != 2) {
            throw new RuntimeException(part + " is not a valid address segment");
        }
        return new AddressPair(addressParts[0], addressParts[1]);
    }

    private static class AddressPair {
        private final String name;
        private final String type;

        public AddressPair(String type, String name) {
            this.name = name;
            this.type = type;
        }
    }
}

