/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.plugin.common.Operations;
import org.jboss.as.plugin.common.Streams;
import org.jboss.dmr.ModelNode;

public class Commands {
    @Parameter
    private boolean batch;
    @Parameter
    private List<String> commands = new ArrayList<String>();
    @Parameter
    private List<File> scripts = new ArrayList<File>();

    public boolean isBatch() {
        return this.batch;
    }

    public boolean hasCommands() {
        return this.commands != null && !this.commands.isEmpty();
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<File> getScripts() {
        return this.scripts;
    }

    public boolean hasScripts() {
        return this.scripts != null && !this.scripts.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(ModelControllerClient client) throws IOException {
        boolean hasCommands = this.hasCommands();
        boolean hasScripts = this.hasScripts();
        if (hasCommands || hasScripts) {
            CommandContext ctx = Commands.create(client);
            try {
                if (this.isBatch()) {
                    this.executeBatch(client, ctx);
                } else {
                    this.executeCommands(client, ctx);
                }
                this.executeScripts(client, ctx);
            }
            finally {
                ctx.terminateSession();
                ctx.bindClient(null);
            }
        }
    }

    private void executeScripts(ModelControllerClient client, CommandContext ctx) throws IOException {
        for (File script : this.getScripts()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(script), "UTF-8"));
                String line = reader.readLine();
                while (ctx.getExitCode() == 0 && !ctx.isTerminated() && line != null) {
                    ctx.handleSafe(line.trim());
                    line = reader.readLine();
                }
            }
            catch (Throwable e) {
                try {
                    throw new IllegalStateException("Failed to process file '" + script.getAbsolutePath() + "'", e);
                }
                catch (Throwable throwable) {
                    Streams.safeClose(reader);
                    throw throwable;
                }
            }
            Streams.safeClose(reader);
        }
    }

    private void executeCommands(ModelControllerClient client, CommandContext ctx) throws IOException {
        for (String cmd : this.getCommands()) {
            ModelNode result;
            try {
                result = client.execute(ctx.buildRequest(cmd));
            }
            catch (CommandFormatException e) {
                throw new IllegalArgumentException(String.format("Command '%s' is invalid", cmd), e);
            }
            if (Operations.successful(result)) continue;
            throw new IllegalArgumentException(String.format("Command '%s' was unsuccessful. Reason: %s", cmd, Operations.getFailureDescription(result)));
        }
    }

    private void executeBatch(ModelControllerClient client, CommandContext ctx) throws IOException {
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        for (String cmd : this.getCommands()) {
            try {
                builder.addStep(ctx.buildRequest(cmd));
            }
            catch (CommandFormatException e) {
                throw new IllegalArgumentException(String.format("Command '%s' is invalid", cmd), e);
            }
        }
        ModelNode result = client.execute(builder.build());
        if (!Operations.successful(result)) {
            throw new IllegalArgumentException(Operations.getFailureDescription(result));
        }
    }

    public static CommandContext create(ModelControllerClient client) {
        CommandContext commandContext;
        try {
            commandContext = CommandContextFactory.getInstance().newCommandContext();
            commandContext.bindClient(client);
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        return commandContext;
    }
}

