/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.server;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.plugin.common.AbstractServerMojo;
import org.jboss.as.plugin.common.ServerOperations;
import org.jboss.dmr.ModelNode;

@Mojo(name="shutdown")
public class Shutdown
extends AbstractServerMojo {
    @Parameter(defaultValue="false", property="jboss-as.reload")
    private boolean reload;
    @Parameter(defaultValue="30", property="jboss-as.reload.timeout", alias="reload-timeout")
    private int reloadTimeout;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().debug((CharSequence)"Skipping server start");
            return;
        }
        try {
            ModelControllerClient client = this.getClient();
            if (this.reload) {
                client.execute(ServerOperations.createOperation((String)"reload"));
                this.waitForStandalone(client, this.reloadTimeout);
            } else {
                client.execute(ServerOperations.createOperation((String)"shutdown"));
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException ignore) {
                ignore.printStackTrace();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s. Reason: %s", this.goal(), e.getMessage()), e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public String goal() {
        return "shutdown";
    }

    private void waitForStandalone(ModelControllerClient client, int startupTimeout) throws InterruptedException, IOException {
        long timeout;
        long sleep = 100L;
        for (timeout = (long)(startupTimeout * 1000); timeout > 0L; timeout -= 100L) {
            long before = System.currentTimeMillis();
            if (this.isStandaloneRunning(client)) break;
            timeout -= System.currentTimeMillis() - before;
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        if (timeout <= 0L) {
            throw new RuntimeException(String.format("The server did not reload within %s seconds.", startupTimeout));
        }
    }

    private boolean isStandaloneRunning(ModelControllerClient client) {
        try {
            ModelNode response = client.execute(ServerOperations.createReadAttributeOperation("server-state"));
            if (ServerOperations.isSuccessfulOutcome((ModelNode)response)) {
                String state = ServerOperations.readResult((ModelNode)response).asString();
                return !"starting".equals(state) && !"stopping".equals(state);
            }
        }
        catch (RuntimeException e) {
            this.getLog().debug((CharSequence)"Interrupted determining if standalone is running", (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)"Error checking if a standalone server is running", (Throwable)e);
        }
        return false;
    }
}

