/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.login;

import java.io.Serializable;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.as.quickstarts.login.Credentials;
import org.jboss.as.quickstarts.login.LoggedIn;
import org.jboss.as.quickstarts.login.User;
import org.jboss.as.quickstarts.login.UserManager;

@SessionScoped
@Named
public class Login
implements Serializable {
    private static final long serialVersionUID = 7965455427888195913L;
    @Inject
    private Credentials credentials;
    @Inject
    private UserManager userManager;
    private User currentUser;

    public void login() throws Exception {
        User user = this.userManager.findUser(this.credentials.getUsername(), this.credentials.getPassword());
        if (user != null) {
            this.currentUser = user;
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Welcome, " + this.currentUser.getName()));
        }
    }

    public void logout() {
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Goodbye, " + this.currentUser.getName()));
        this.currentUser = null;
    }

    public boolean isLoggedIn() {
        return this.currentUser != null;
    }

    @Produces
    @LoggedIn
    public User getCurrentUser() {
        return this.currentUser;
    }
}

