/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.login;

import java.util.List;
import java.util.logging.Logger;
import javax.ejb.Stateful;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import org.jboss.as.quickstarts.login.User;
import org.jboss.as.quickstarts.login.UserManager;

@Named(value="userManager")
@RequestScoped
@Alternative
@Stateful
public class EJBUserManager
implements UserManager {
    @Inject
    private transient Logger logger;
    @Inject
    private EntityManager userDatabase;
    private User newUser = new User();

    @Produces
    @Named
    @RequestScoped
    @Alternative
    public List<User> getUsers() throws Exception {
        return this.userDatabase.createQuery("select u from User u").getResultList();
    }

    public String addUser() throws Exception {
        this.userDatabase.persist((Object)this.newUser);
        this.logger.info("Added " + this.newUser);
        return "userAdded";
    }

    public User findUser(String username, String password) throws Exception {
        List results = this.userDatabase.createQuery("select u from User u where u.username=:username and u.password=:password").setParameter("username", (Object)username).setParameter("password", (Object)password).getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("Cannot have more than one user with the same username!");
        }
        return (User)results.get(0);
    }

    @Produces
    @RequestScoped
    @Named
    @Alternative
    public User getNewUser() {
        return this.newUser;
    }
}

