/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.login;

import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import org.jboss.as.quickstarts.login.User;
import org.jboss.as.quickstarts.login.UserManager;

@Named(value="userManager")
@RequestScoped
public class ManagedBeanUserManager
implements UserManager {
    @Inject
    private transient Logger logger;
    @Inject
    private EntityManager userDatabase;
    @Inject
    private UserTransaction utx;
    private User newUser = new User();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Produces
    @Named
    @RequestScoped
    public List<User> getUsers() throws Exception {
        List list;
        try {
            this.utx.begin();
            list = this.userDatabase.createQuery("select u from User u").getResultList();
        }
        catch (Throwable throwable) {
            try {
                this.utx.commit();
                throw throwable;
            }
            catch (Exception e) {
                this.utx.rollback();
                throw e;
            }
        }
        this.utx.commit();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addUser() throws Exception {
        try {
            try {
                this.utx.begin();
                this.userDatabase.persist((Object)this.newUser);
                this.logger.info("Added " + this.newUser);
            }
            finally {
                this.utx.commit();
            }
        }
        catch (Exception e) {
            this.utx.rollback();
            throw e;
        }
        return "userAdded";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User findUser(String username, String password) throws Exception {
        try {
            try {
                this.utx.begin();
                List results = this.userDatabase.createQuery("select u from User u where u.username=:username and u.password=:password").setParameter("username", (Object)username).setParameter("password", (Object)password).getResultList();
                if (results.isEmpty()) {
                    User user = null;
                    return user;
                }
                if (results.size() > 1) {
                    throw new IllegalStateException("Cannot have more than one user with the same username!");
                }
                User user = (User)results.get(0);
                return user;
            }
            finally {
                this.utx.commit();
            }
        }
        catch (Exception e) {
            this.utx.rollback();
            throw e;
        }
    }

    @Produces
    @RequestScoped
    @Named
    public User getNewUser() {
        return this.newUser;
    }
}

