/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.test;

import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.test.AbstractTestDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectTestDelegate
extends AbstractTestDelegate {
    private static final List<URL> urls = new CopyOnWriteArrayList<URL>();

    public AspectTestDelegate(Class<?> clazz) {
        super(clazz);
    }

    public void setUp() throws Exception {
        super.setUp();
        String aopXmlName = this.clazz.getName().replace(".", "/") + "-aop.xml";
        URL url = this.clazz.getClassLoader().getResource(aopXmlName);
        if (url == null) {
            throw new IllegalStateException("Can't find resource " + aopXmlName);
        }
        AspectXmlLoader.deployXML((URL)url);
        urls.add(url);
    }

    public void tearDown() throws Exception {
        for (URL url : urls) {
            AspectXmlLoader.undeployXML((URL)url);
        }
        super.tearDown();
    }
}

