/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.proxy.ProxyFactory;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.IsLocalInterceptor;
import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
import org.jboss.aspects.remoting.PojiProxy;
import org.jboss.aspects.security.SecurityClientInterceptor;
import org.jboss.aspects.tx.ClientTxPropagationInterceptor;
import org.jboss.remoting.InvokerLocator;
import org.jboss.util.id.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Remoting {
    public static ClassProxy createRemoteProxy(Object objectId, Class clazz, String uri) throws Exception {
        return Remoting.createRemoteProxy(objectId, clazz, new InvokerLocator(uri));
    }

    public static ClassProxy createRemoteProxy(Object objectId, Class clazz, InvokerLocator locator) throws Exception {
        ClassProxy proxy = ClassProxyFactory.newInstance((Class)clazz);
        Remoting.makeRemotable((InstanceAdvised)proxy, locator, objectId);
        return proxy;
    }

    public static org.jboss.aop.proxy.Proxy createRemoteProxy(Object objectId, ClassLoader loader, Class[] ifaces, InvokerLocator locator) throws Exception {
        GUID guid = new GUID();
        org.jboss.aop.proxy.Proxy proxy = ProxyFactory.createInterfaceProxy((GUID)guid, (ClassLoader)loader, (Class[])ifaces);
        Remoting.makeRemotable((InstanceAdvised)proxy, locator, objectId);
        return proxy;
    }

    public static org.jboss.aop.proxy.Proxy createRemoteProxy(Object objectId, ClassLoader loader, Class[] ifaces, InvokerLocator locator, List<Interceptor> interceptors, String subsystem) throws Exception {
        GUID guid = new GUID();
        org.jboss.aop.proxy.Proxy proxy = ProxyFactory.createInterfaceProxy((GUID)guid, (ClassLoader)loader, (Class[])ifaces);
        Remoting.makeRemotable((InstanceAdvised)proxy, locator, objectId, interceptors, subsystem);
        return proxy;
    }

    public static Object createPojiProxy(Object oid, Class[] interfaces, String uri) throws Exception {
        InvokerLocator locator = new InvokerLocator(uri);
        Interceptor[] interceptors = new Interceptor[]{IsLocalInterceptor.singleton, InvokeRemoteInterceptor.singleton};
        PojiProxy proxy = new PojiProxy(oid, locator, interceptors);
        return Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)proxy);
    }

    public static Object createPojiProxy(Object oid, Class[] interfaces, String uri, Interceptor[] interceptors) throws Exception {
        InvokerLocator locator = new InvokerLocator(uri);
        PojiProxy proxy = new PojiProxy(oid, locator, interceptors);
        return Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)proxy);
    }

    public static void makeRemotable(InstanceAdvised proxy, InvokerLocator locator, Object objectId) {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        interceptors.add(IsLocalInterceptor.singleton);
        interceptors.add((Interceptor)SecurityClientInterceptor.singleton);
        interceptors.add((Interceptor)ClientTxPropagationInterceptor.singleton);
        interceptors.add(MergeMetaDataInterceptor.singleton);
        interceptors.add(InvokeRemoteInterceptor.singleton);
        Remoting.makeRemotable(proxy, locator, objectId, interceptors, "AOP");
    }

    public static void makeRemotable(InstanceAdvised proxy, InvokerLocator locator, Object objectId, List<Interceptor> interceptors, String subsystem) {
        InstanceAdvisor advisor = proxy._getInstanceAdvisor();
        for (Interceptor i : interceptors) {
            advisor.insertInterceptor(i);
        }
        advisor.getMetaData().addMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR", (Object)locator, PayloadKey.AS_IS);
        advisor.getMetaData().addMetaData((Object)"REMOTING", (Object)"SUBSYSTEM", (Object)subsystem, PayloadKey.AS_IS);
        advisor.getMetaData().addMetaData((Object)"DISPATCHER", (Object)"OID", objectId, PayloadKey.AS_IS);
    }
}

