/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.security.GeneralSecurityException;
import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.security.SecurityActions;
import org.jboss.aspects.security.SecurityContext;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RunAsIdentity;

public class AuthenticationInterceptor
implements Interceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    protected AuthenticationManager authenticationManager;

    public AuthenticationInterceptor(AuthenticationManager manager) {
        this.authenticationManager = manager;
    }

    public String getName() {
        return "AuthenticationInterceptor";
    }

    protected void handleGeneralSecurityException(GeneralSecurityException gse) {
        throw new SecurityException(gse.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        try {
            this.authenticate(invocation);
        }
        catch (GeneralSecurityException gse) {
            this.handleGeneralSecurityException(gse);
        }
        Object oldDomain = SecurityContext.currentDomain.get();
        try {
            SecurityContext.currentDomain.set(this.authenticationManager);
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            SecurityContext.currentDomain.set(oldDomain);
            RunAsIdentity callerRunAsIdentity = SecurityActions.peekRunAsIdentity();
            if (this.authenticationManager == null || callerRunAsIdentity == null) {
                SecurityActions.popSubjectContext();
            }
            if (this.authenticationManager != null) {
                SecurityActions.clearSecurityContext();
            }
            if (invocation.getMetaData((Object)"security", (Object)"principal") != null) {
                SecurityActions.setPrincipal(null);
                SecurityActions.setCredential(null);
            }
        }
    }

    protected void authenticate(Invocation invocation) throws Exception {
        Principal principal = (Principal)invocation.getMetaData((Object)"security", (Object)"principal");
        Object credential = invocation.getMetaData((Object)"security", (Object)"credential");
        if (principal == null) {
            principal = SecurityActions.getPrincipal();
        }
        if (credential == null) {
            credential = SecurityActions.getCredential();
        }
        if (this.authenticationManager == null) {
            SecurityActions.pushSubjectContext(principal, credential, null);
            return;
        }
        RunAsIdentity callerRunAsIdentity = SecurityActions.peekRunAsIdentity();
        if (callerRunAsIdentity == null) {
            Subject subject = new Subject();
            if (!this.authenticationManager.isValid(principal, credential, subject)) {
                Exception ex = SecurityActions.getContextException();
                if (ex != null) {
                    throw ex;
                }
                String msg = "Authentication exception, principal=" + principal;
                SecurityException e = new SecurityException(msg);
                throw e;
            }
            SecurityActions.pushSubjectContext(principal, credential, subject);
            SecurityActions.establishSecurityContext(this.authenticationManager.getSecurityDomain(), principal, credential, subject);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Authenticated  principal=" + principal));
            }
        }
    }
}

